/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler.encoding;

import com.aspectran.undertow.server.handler.encoding.ContentEncodingPredicates;
import com.aspectran.utils.annotation.jsr305.Nullable;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import java.util.ArrayList;

public class EncodingHandlerWrapper
implements HandlerWrapper {
    private static final String GZIP = "gzip";
    private static final String DEFLATE = "deflate";
    private String[] encodingProviderNames;
    private ContentEncodingPredicates[] encodingPredicates;

    public void setEncodingProviders(String ... encodingProviderNames) {
        this.encodingProviderNames = encodingProviderNames;
    }

    public void setEncodingPredicates(ContentEncodingPredicates ... encodingPredicates) {
        this.encodingPredicates = encodingPredicates;
    }

    public HttpHandler wrap(HttpHandler handler) {
        ContentEncodingRepository contentEncodingRepository = new ContentEncodingRepository();
        if (this.encodingProviderNames != null && this.encodingProviderNames.length != 0) {
            Predicate predicate = this.createPredicate();
            int priority = this.encodingProviderNames.length;
            for (String providerName : this.encodingProviderNames) {
                if (GZIP.equalsIgnoreCase(providerName)) {
                    contentEncodingRepository.addEncodingHandler(GZIP, (ContentEncodingProvider)new GzipEncodingProvider(), priority, predicate);
                } else if (DEFLATE.equalsIgnoreCase(providerName)) {
                    contentEncodingRepository.addEncodingHandler(DEFLATE, (ContentEncodingProvider)new DeflateEncodingProvider(), priority, predicate);
                } else {
                    throw new IllegalArgumentException("Unknown content encoding provider '" + providerName + "'");
                }
                --priority;
            }
        }
        return new EncodingHandler(handler, contentEncodingRepository);
    }

    @Nullable
    private Predicate createPredicate() {
        Predicate predicate = null;
        if (this.encodingPredicates != null && this.encodingPredicates.length > 0) {
            if (this.encodingPredicates.length == 1) {
                predicate = this.encodingPredicates[0].createPredicate();
            } else {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>(this.encodingPredicates.length);
                for (ContentEncodingPredicates compressionPredicate : this.encodingPredicates) {
                    predicates.add(compressionPredicate.createPredicate());
                }
                predicate = Predicates.or((Predicate[])predicates.toArray(new Predicate[0]));
            }
        }
        return predicate;
    }
}

