/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.service.CoreService;
import com.aspectran.undertow.server.servlet.TowFilter;
import com.aspectran.undertow.server.servlet.TowFilterServletMapping;
import com.aspectran.undertow.server.servlet.TowFilterUrlMapping;
import com.aspectran.undertow.server.servlet.TowListener;
import com.aspectran.undertow.server.servlet.TowServlet;
import com.aspectran.undertow.server.servlet.TowWebSocketInitializer;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.DefaultWebServiceBuilder;
import com.aspectran.web.service.WebServiceClassLoader;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.hc.core5.util.Asserts;

public class TowServletContext
extends DeploymentInfo
implements ActivityContextAware {
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private ActivityContext context;
    private ClassLoader altClassLoader;
    private SessionManager sessionManager;

    @NonNull
    public ActivityContext getActivityContext() {
        return this.context;
    }

    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.context = context;
        this.altClassLoader = new WebServiceClassLoader(context.getClassLoader());
        this.setClassLoader(this.altClassLoader);
    }

    @NonNull
    public ApplicationAdapter getApplicationAdapter() {
        return this.getActivityContext().getApplicationAdapter();
    }

    @NonNull
    public ClassLoader getAltClassLoader() {
        return this.altClassLoader;
    }

    public void setScratchDir(String scratchDir) throws IOException {
        File dir = this.getApplicationAdapter().toRealPathAsFile(scratchDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.setTempDir(this.getApplicationAdapter().toRealPathAsFile(scratchDir));
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.setSessionManagerFactory(deployment -> sessionManager);
    }

    public void setInitParams(Map<String, String> initParams) {
        if (initParams != null) {
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                this.addInitParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setListeners(TowListener[] towListeners) {
        if (towListeners != null) {
            for (TowListener towListener : towListeners) {
                this.addListener(towListener);
            }
        }
    }

    public void setServlets(TowServlet[] towServlets) {
        if (towServlets != null) {
            for (TowServlet towServlet : towServlets) {
                ServletInfo existingServlet = (ServletInfo)this.getServlets().get(towServlet.getName());
                if (this.getServlets().containsKey(towServlet.getName())) {
                    throw new IllegalArgumentException("Duplicate servlet name detected: Existing: " + existingServlet + "; This: " + towServlet + "; Each servlet added to the servlet context must have a unique name. Otherwise existing servlets will be ignored.");
                }
                this.addServlet(towServlet);
            }
        }
    }

    public void setFilters(TowFilter[] towFilters) {
        if (towFilters != null) {
            for (TowFilter towFilter : towFilters) {
                this.addFilter(towFilter);
            }
        }
    }

    public void setFilterUrlMappings(TowFilterUrlMapping[] towFilterUrlMappings) {
        if (towFilterUrlMappings != null) {
            for (TowFilterUrlMapping filterUrlMapping : towFilterUrlMappings) {
                this.addFilterUrlMapping(filterUrlMapping.getFilterName(), filterUrlMapping.getMapping(), filterUrlMapping.getDispatcher());
            }
        }
    }

    public void setFilterServletMappings(TowFilterServletMapping[] towFilterServletMappings) {
        if (towFilterServletMappings != null) {
            for (TowFilterServletMapping filterServletMapping : towFilterServletMappings) {
                this.addFilterServletNameMapping(filterServletMapping.getFilterName(), filterServletMapping.getMapping(), filterServletMapping.getDispatcher());
            }
        }
    }

    public void setServletContainerInitializers(ServletContainerInitializer[] servletContainerInitializers) {
        Asserts.notNull((Object)servletContainerInitializers, (String)"servletContainerInitializers must not be null");
        for (ServletContainerInitializer initializer : servletContainerInitializers) {
            Class<?> servletContainerInitializerClass = initializer.getClass();
            ImmediateInstanceFactory instanceFactory = new ImmediateInstanceFactory((Object)initializer);
            ServletContainerInitializerInfo sciInfo = new ServletContainerInitializerInfo(servletContainerInitializerClass, (InstanceFactory)instanceFactory, NO_CLASSES);
            this.addServletContainerInitializer(sciInfo);
        }
    }

    public void setWelcomePages(String[] welcomePages) {
        if (welcomePages != null) {
            this.addWelcomePages(welcomePages);
        }
    }

    public void setErrorPages(ErrorPage[] errorPages) {
        if (errorPages != null) {
            this.addErrorPages(errorPages);
        }
    }

    public void setInitialHandlerChainWrappers(HandlerWrapper[] wrappers) {
        if (wrappers != null) {
            for (HandlerWrapper wrapper : wrappers) {
                this.addInitialHandlerChainWrapper(wrapper);
            }
        }
    }

    public void setInnerHandlerChainWrappers(HandlerWrapper[] wrappers) {
        if (wrappers != null) {
            for (HandlerWrapper wrapper : wrappers) {
                this.addInnerHandlerChainWrapper(wrapper);
            }
        }
    }

    public void setOuterHandlerChainWrappers(HandlerWrapper[] wrappers) {
        if (wrappers != null) {
            for (HandlerWrapper wrapper : wrappers) {
                this.addOuterHandlerChainWrapper(wrapper);
            }
        }
    }

    public void setWebSocketInitializer(TowWebSocketInitializer webSocketInitializer) {
        if (webSocketInitializer != null) {
            webSocketInitializer.initialize(this);
        }
    }

    void createRootWebService(ServletContext servletContext) throws Exception {
        CoreService rootService = this.getActivityContext().getRootService();
        DefaultWebService rootWebService = DefaultWebServiceBuilder.build((ServletContext)servletContext, (CoreService)rootService, (ClassLoader)this.getAltClassLoader());
        if (rootWebService.isLateStart()) {
            rootWebService.getServiceController().start();
        }
    }
}

