/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.utils.ResourceUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.jasper.servlet.TldScanner;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.scan.JarFactory;
import org.xml.sax.SAXException;

public class TowTldScanner
extends TldScanner {
    private final Logger logger = LoggerFactory.getLogger(TowTldScanner.class);
    private URL[] tldResources;

    public TowTldScanner(ServletContext context, boolean namespaceAware, boolean validation, boolean blockExternal) {
        super(context, namespaceAware, validation, blockExternal);
    }

    public void setTldResources(URL[] tldResources) {
        this.tldResources = tldResources;
    }

    public void scan() throws IOException, SAXException {
        this.scanPlatform();
        this.scanJspConfig();
        this.scanResourcePaths("/WEB-INF/");
        if (this.tldResources != null) {
            for (URL url : this.tldResources) {
                if (url == null) continue;
                if (url.getPath().endsWith(".tld")) {
                    this.parseTld(url);
                    continue;
                }
                if (ResourceUtils.isJarURL((URL)url) || ResourceUtils.isJarFileURL((URL)url)) {
                    Jar jar = JarFactory.newInstance((URL)url);
                    this.scanJar(jar);
                    continue;
                }
                if (ResourceUtils.isFileURL((URL)url)) {
                    File dir = ResourceUtils.getFile((URL)url);
                    if (!dir.isDirectory()) continue;
                    this.scanDir(dir);
                    continue;
                }
                this.logger.warn("Unrecognized TLD Resource: " + url);
            }
        }
        Map result = this.getUriTldResourcePathMap();
        for (Map.Entry entry : result.entrySet()) {
            this.logger.debug("Found TLD: " + (String)entry.getKey() + " [" + ((TldResourcePath)entry.getValue()).getUrl() + "]");
        }
    }

    private void scanDir(@NonNull File dir) {
        dir.listFiles(file -> {
            String filePath;
            if (file.isFile() && (filePath = file.getAbsolutePath()).toLowerCase().endsWith(".jar")) {
                try {
                    Jar jar = JarFactory.newInstance((URL)file.toURI().toURL());
                    this.scanJar(jar);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        });
    }

    private void parseTld(URL url) throws IOException {
        TldResourcePath tldResourcePath = new TldResourcePath(url, null);
        try {
            this.parseTld(tldResourcePath);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse TLD: " + url, e);
        }
    }

    private void scanJar(@NonNull Jar jar) throws IOException {
        boolean found = false;
        URL jarFileUrl = jar.getJarFileURL();
        jar.nextEntry();
        String entryName = jar.getEntryName();
        while (entryName != null) {
            if (entryName.startsWith("META-INF/") && entryName.endsWith(".tld")) {
                found = true;
                TldResourcePath tldResourcePath = new TldResourcePath(jarFileUrl, null, entryName);
                try {
                    this.parseTld(tldResourcePath);
                }
                catch (SAXException e) {
                    throw new IOException("Failed to parse TLD: ", e);
                }
            }
            jar.nextEntry();
            entryName = jar.getEntryName();
        }
        if (!found && this.logger.isDebugEnabled()) {
            this.logger.debug("No TLDs were found in JAR [" + jarFileUrl + "]");
        }
    }
}

