/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.undertow.server.session.TowSessionManager;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.util.AttachmentKey;
import java.util.Set;

final class TowSessionBridge
implements Session {
    private final AttachmentKey<Boolean> FIRST_REQUEST_ACCESSED = AttachmentKey.create(Boolean.class);
    private final com.aspectran.core.component.session.Session session;
    private final TowSessionManager sessionManager;

    TowSessionBridge(com.aspectran.core.component.session.Session session, TowSessionManager sessionManager) {
        this.session = session;
        this.sessionManager = sessionManager;
    }

    public String getId() {
        return this.session.getId();
    }

    void requestStarted(@NonNull HttpServerExchange exchange) {
        Boolean existing = (Boolean)exchange.getAttachment(this.FIRST_REQUEST_ACCESSED);
        if (existing == null) {
            exchange.putAttachment(this.FIRST_REQUEST_ACCESSED, (Object)true);
            this.session.access();
        }
    }

    public void requestDone(HttpServerExchange exchange) {
        this.session.complete();
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this.session.getAttributeNames();
    }

    public Object setAttribute(String name, Object value) {
        return this.session.setAttribute(name, value);
    }

    public Object removeAttribute(String name) {
        return this.session.removeAttribute(name);
    }

    public void invalidate(HttpServerExchange exchange) {
        this.session.invalidate();
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        com.aspectran.core.component.session.Session session = this.session;
        synchronized (session) {
            if (!this.session.isValid()) {
                return null;
            }
            String oldId = this.session.getId();
            String newId = this.sessionManager.getSessionHandler().createSessionId((long)this.hashCode());
            String sessionId = this.sessionManager.getSessionHandler().renewSessionId(oldId, newId);
            if (sessionId != null) {
                config.setSessionId(exchange, sessionId);
            }
            return sessionId;
        }
    }
}

