/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class ActionUtil {
    public static String getRequestIP() {
        HttpServletRequest request = ActionUtil.getRequest();
        String ip = request.getHeader("X-Real-IP");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip == null) {
            return null;
        }
        return ip.split(",")[0];
    }

    public static String getLocalInnerIP() {
        String reqIp = null;
        try {
            reqIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return reqIp;
    }

    public static String getLocalOuterIP() {
        String netIp = null;
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
        InetAddress ip = null;
        boolean found = false;
        block2: while (netInterfaces != null && netInterfaces.hasMoreElements() && !found) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                ip = address.nextElement();
                if (ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") >= 0) continue;
                netIp = ip.getHostAddress();
                found = true;
                continue block2;
            }
        }
        if (netIp != null && !"".equals(netIp.trim())) {
            return netIp.trim();
        }
        return null;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return sra == null ? null : sra.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return sra == null ? null : sra.getResponse();
    }

    public static void addContextPath() {
        ActionUtil.addContextPath(ActionUtil.getRequest());
    }

    public static void addContextPath(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder("");
        builder.append(request.getScheme()).append("://").append(request.getServerName());
        int port = request.getServerPort();
        if (port != 80 && port != 443) {
            builder.append(":").append(port);
        }
        builder.append(request.getContextPath());
        request.getServletContext().setAttribute("contextPath", (Object)builder.toString());
    }

    public static String getContextPath() {
        return ActionUtil.getContextPath(ActionUtil.getRequest());
    }

    public static String getContextPath(HttpServletRequest request) {
        return (String)request.getServletContext().getAttribute("contextPath");
    }

    public static void addStaticPath(String staticPath) {
        ActionUtil.addStaticPath(ActionUtil.getRequest(), staticPath);
    }

    public static void addStaticPath(HttpServletRequest request, String staticPath) {
        request.getServletContext().setAttribute("staticPath", (Object)staticPath);
    }

    public static String getStaticPath() {
        return ActionUtil.getStaticPath(ActionUtil.getRequest());
    }

    public static String getStaticPath(HttpServletRequest request) {
        return (String)request.getServletContext().getAttribute("staticPath");
    }

    public static void output(String str) {
        try {
            ActionUtil.output(str.getBytes("utf-8"), "text/html");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void output(byte[] content, String contentType) {
        HttpServletResponse response = ActionUtil.getResponse();
        response.setContentType(contentType + "; charset=" + "utf-8");
        response.setHeader("Cache-Control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            response.getOutputStream().write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String forward(String url) {
        return "forward:" + url;
    }

    public static String redirect(String url) {
        return "redirect:" + url;
    }
}

