/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.util.Assert;

public abstract class BeanUtil {
    private static final String[] strs = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public static String getAlphaString(Map<String, ? extends Object> map, String conn) {
        return BeanUtil.getAlphaString(map, conn, null);
    }

    public static String getAlphaString(Map<String, ? extends Object> map, String conn, String charset) {
        Assert.notNull((Object)conn, (String)"[conn] is required.");
        if (map == null || map.isEmpty()) {
            return "";
        }
        Set<String> keys = map.keySet();
        ArrayList<String> list = new ArrayList<String>();
        for (String k : keys) {
            Object v = map.get(k);
            if (v == null) {
                v = "";
            } else if (charset != null) {
                try {
                    k = URLEncoder.encode(k, charset);
                    v = URLEncoder.encode(v.toString(), charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            list.add(k + "=" + v);
        }
        Collections.sort(list);
        StringBuilder builder = new StringBuilder("");
        for (String kv : list) {
            builder.append(kv).append(conn);
        }
        if (conn.length() > 0) {
            builder.delete(builder.length() - conn.length(), builder.length());
        }
        return builder.toString();
    }

    public static String getRandCode(int length) {
        Random random = new Random();
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < length; ++i) {
            builder.append(strs[random.nextInt(strs.length)]);
        }
        return builder.toString();
    }

    public static boolean isEmail(String email) {
        if (email == null || "".equals(email.trim())) {
            return false;
        }
        String regex = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(email.trim());
        return m.find();
    }

    public static boolean isMobile(String mobile) {
        if (mobile == null || "".equals(mobile.trim())) {
            return false;
        }
        Pattern p = Pattern.compile("^[1][3-8]\\d{9}$");
        Matcher m = p.matcher(mobile.trim());
        return m.find();
    }

    public static boolean isPhone(String phone) {
        if (phone == null || "".equals(phone.trim())) {
            return false;
        }
        Pattern p = Pattern.compile("^[\\d]{5,20}$");
        Matcher m = p.matcher(phone.trim());
        return m.find();
    }

    public static String cutString(String str, int len) {
        if (str == null || str.length() <= 0 || len <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder("");
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ((count += BeanUtil.isChineseChar(c) ? 2 : 1) > len) {
                builder.append("......");
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String escape(String str) {
        if (str == null || str.length() <= 0) {
            return "";
        }
        return str.trim().replace("<", "&lt;").replace(">", "&gt;").replace("\"", "\\\"").replace("\r\n", "<br/>").replace("\n", "<br/>");
    }

    public static String escape2(String str) {
        if (str == null || str.length() <= 0) {
            return "";
        }
        return str.trim().replace("\"", "\\\"").replace("\r\n", "<br/>").replace("\n", "<br/>");
    }

    public static boolean isChineseChar(char c) {
        return Character.isLetter(c) && c > '\u00ff';
    }

    public static String getDomainUrl(String url) {
        try {
            StringBuilder builder = new StringBuilder("");
            URL _url = new URL(url);
            builder.append(_url.getProtocol()).append("://").append(_url.getHost());
            int port = _url.getPort();
            if (port != 80 && port != 443 && port > 0) {
                builder.append(":").append(port);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T copyProperties(Object source, Class<T> targetClass) {
        if (source == null) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        try {
            Constructor<T> constructor = targetClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T targetObj = constructor.newInstance(new Object[0]);
            BeanUtils.copyProperties(targetObj, (Object)source);
            return targetObj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void copyProperties(Object source, T target) {
        if (source == null || target == null) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        try {
            BeanUtils.copyProperties(target, (Object)source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String join(T[] arr, String separator) {
        if (arr == null || arr.length <= 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (T t : arr) {
            builder.append(separator).append(t.toString());
        }
        builder.delete(0, separator.length());
        return builder.toString();
    }
}

