/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import com.assist4j.core.ActionUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CookieUtil {
    public static final int COOKIE_MAXAGE_1W = 604800;
    public static final int COOKIE_MAXAGE_DEFAULT = -1;

    public static String findValueByKey(String key) {
        HttpServletRequest request = ActionUtil.getRequest();
        if (request == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length <= 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(key)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void addCookie(String name, String value) {
        CookieUtil.addCookie(name, value, null, -1);
    }

    public static void addCookie(String name, String value, int maxAge) {
        CookieUtil.addCookie(name, value, null, maxAge);
    }

    public static void addCookie(String name, String value, String domain, int maxAge) {
        HttpServletRequest request = ActionUtil.getRequest();
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            contextPath = "/";
        }
        CookieUtil.addCookie(name, value, domain, contextPath, maxAge);
    }

    public static void addCookie(String name, String value, String domain, String contextPath, int maxAge) {
        HttpServletRequest request = ActionUtil.getRequest();
        HttpServletResponse response = ActionUtil.getResponse();
        if (request == null || response == null) {
            throw new RuntimeException("Request and response can not be null.");
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(request.isSecure());
        if (contextPath == null || contextPath.isEmpty()) {
            cookie.setPath("/");
        } else {
            cookie.setPath(contextPath);
        }
        if (domain != null && !domain.isEmpty()) {
            cookie.setDomain(domain);
        }
        response.addCookie(cookie);
    }

    public static void invalidate() {
        Cookie[] cookies = ActionUtil.getRequest().getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = new Cookie(cookies[i].getName(), null);
                cookie.setValue("");
                cookie.setMaxAge(0);
                cookie.setPath("/");
                ActionUtil.getResponse().addCookie(cookie);
            }
        }
    }
}

