/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class DateUtil {
    public static final String PATTERN_YM = "yyyy-MM";
    public static final String PATTERN_DATE1 = "yyyy-MM-dd";
    public static final String PATTERN_DATE2 = "yyyy/MM/dd";
    public static final String PATTERN_DATE3 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String PATTERN_DATE4 = "yyyyMMdd";
    public static final String PATTERN_TIME1 = "HH:mm";
    public static final String PATTERN_TIME2 = "HH:mm:ss";
    public static final String PATTERN_DATE_TIME1 = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String PATTERN_DATE_TIME2 = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE_TIME3 = "yyyyMMddHHmmss";
    public static final String PATTERN_DATE_TIME4 = "yyyyMMddHHmm";
    public static final String PATTERN_DATE_TIME5 = "yyyyMMddHH";
    public static final String PATTERN_DATE_TIME6 = "yyyyMMddHHmmssSSS";
    public static final String PATTERN_DATE_TIME7 = "yyyy-MM-dd HH:mm";
    public static final String PATTERN_DATE_TIME8 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final int UNIT_YEAR = 1;
    public static final int UNIT_MONTH = 2;
    public static final int UNIT_WEEK = 3;
    public static final int UNIT_DAY = 4;
    public static final int UNIT_HOUR = 5;
    public static final int UNIT_MINUTE = 6;
    public static final int UNIT_SECOND = 7;

    public static int getCurYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static String formatDate(Date date) {
        return new SimpleDateFormat(PATTERN_DATE1).format(date);
    }

    public static String formatDate(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static Date parseDate(String dateStr, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getDateOffset(Date date, int offset, int unit) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (offset != 0) {
            switch (unit) {
                case 1: {
                    ((Calendar)cal).add(1, offset);
                    break;
                }
                case 2: {
                    ((Calendar)cal).add(2, offset);
                    break;
                }
                case 3: {
                    ((Calendar)cal).add(3, offset);
                    break;
                }
                case 4: {
                    ((Calendar)cal).add(6, offset);
                    break;
                }
                case 5: {
                    ((Calendar)cal).add(11, offset);
                    break;
                }
                case 6: {
                    ((Calendar)cal).add(12, offset);
                    break;
                }
                case 7: {
                    ((Calendar)cal).add(13, offset);
                }
            }
        }
        return cal.getTime();
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getMinute(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(12);
    }

    public static int getSecond(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(13);
    }

    public static Date getNextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date getStartOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastSecOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        int y1 = DateUtil.getYear(date1);
        int m1 = DateUtil.getMonth(date1);
        int d1 = DateUtil.getDay(date1);
        int y2 = DateUtil.getYear(date2);
        int m2 = DateUtil.getMonth(date2);
        int d2 = DateUtil.getDay(date2);
        return y1 == y2 && m1 == m2 && d1 == d2;
    }

    public static void validate(int year, int month, int day) {
        if (year < 1) {
            throw new IllegalArgumentException("\u5e74\u4efd\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("\u6708\u4efd\u53ea\u80fd\u53d6\u503c1~12");
        }
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month);
        c.set(5, 1);
        c.add(5, -1);
        int lastDay = c.get(5);
        if (day < 1 || day > lastDay) {
            throw new IllegalArgumentException("\u65e5\u53d6\u503c\u4e0d\u80fd\u8d85\u8fc71~" + lastDay);
        }
    }

    public static int getDayDiff(Date date1, Date date2) {
        long dif = (date2.getTime() - date1.getTime()) / 86400000L;
        return (int)dif;
    }
}

