/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdCardUtil {
    private static final Logger log = LoggerFactory.getLogger(IdCardUtil.class);
    private static final int CHINA_ID_NO_1_LENGTH = 15;
    private static final int CHINA_ID_NO_2_LENGTH = 18;
    private static final int[] WEIGHT_FACTORS = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static Map<String, String> cityCodes = new HashMap<String, String>();
    private static Map<String, Integer> twFirstCode = new HashMap<String, Integer>();
    private static Map<String, Integer> hkFirstCode = new HashMap<String, Integer>();

    private static String convert15To18(String cardNo) {
        if (cardNo == null || cardNo.length() != 15) {
            return null;
        }
        if (!IdCardUtil.isNum(cardNo)) {
            return null;
        }
        String birthday = cardNo.substring(6, 12);
        Calendar cal = Calendar.getInstance();
        try {
            Date birthDate = new SimpleDateFormat("yyMMdd").parse(birthday);
            cal.setTime(birthDate);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
        String sYear = String.valueOf(cal.get(1));
        String idCard18 = cardNo.substring(0, 6) + sYear + cardNo.substring(8);
        char[] cArr = idCard18.toCharArray();
        if (cArr == null) {
            return null;
        }
        int[] iCard = IdCardUtil.convertCharToInt(cArr);
        int iSum17 = IdCardUtil.getPowerSum(iCard);
        String sVal = IdCardUtil.getCheckCode18(iSum17);
        if (sVal == null || sVal.length() <= 0) {
            return null;
        }
        return idCard18 + sVal;
    }

    public static boolean check(String cardNo) {
        if (cardNo == null) {
            return false;
        }
        String cardNo0 = cardNo.trim();
        if (IdCardUtil.check18(cardNo0)) {
            return true;
        }
        return IdCardUtil.check15(cardNo0);
    }

    private static boolean check18(String cardNo) {
        if (cardNo == null || cardNo.length() != 18) {
            return false;
        }
        String code17 = cardNo.substring(0, 17);
        String code18 = cardNo.substring(17, 18);
        if (!IdCardUtil.isNum(code17)) {
            return false;
        }
        char[] cArr = code17.toCharArray();
        if (cArr == null) {
            return false;
        }
        int[] iCard = IdCardUtil.convertCharToInt(cArr);
        int iSum17 = IdCardUtil.getPowerSum(iCard);
        String val = IdCardUtil.getCheckCode18(iSum17);
        return code18.equalsIgnoreCase(val);
    }

    private static boolean check15(String cardNo) {
        if (cardNo == null || cardNo.length() != 15) {
            return false;
        }
        if (!IdCardUtil.isNum(cardNo)) {
            return false;
        }
        String proCode = cardNo.substring(0, 2);
        if (cityCodes.get(proCode) == null) {
            return false;
        }
        String birthCode = cardNo.substring(6, 12);
        try {
            Date birthday = new SimpleDateFormat("yyMMdd").parse(birthCode);
            return birthday.before(new Date());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    public static boolean checkTwCard(String cardNo) {
        if (cardNo == null) {
            return false;
        }
        String start = cardNo.substring(0, 1);
        String mid = cardNo.substring(1, 9);
        String end = cardNo.substring(9, 10);
        int iStart = twFirstCode.get(start);
        int sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        int iflag = 8;
        for (char c : chars) {
            sum += Integer.valueOf(c + "") * iflag;
            --iflag;
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.valueOf(end);
    }

    public static boolean checkHkCard(String cardNo) {
        if (cardNo == null) {
            return false;
        }
        String card = cardNo.replaceAll("[\\(|\\)]", "");
        int sum = 0;
        if (card.length() == 9) {
            sum = (Integer.valueOf(card.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 9 + (Integer.valueOf(card.substring(1, 2).toUpperCase().toCharArray()[0]) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Integer.valueOf(card.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        Integer iflag = 7;
        for (char c : chars) {
            sum += Integer.valueOf(c + "") * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        sum = end.toUpperCase().equals("A") ? (sum += 10) : (sum += Integer.valueOf(end).intValue());
        return sum % 11 == 0;
    }

    private static int[] convertCharToInt(char[] ch) {
        if (ch == null) {
            return null;
        }
        int len = ch.length;
        int[] iArr = new int[len];
        try {
            for (int i = 0; i < len; ++i) {
                iArr[i] = Integer.parseInt(String.valueOf(ch[i]));
            }
            return iArr;
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    private static int getPowerSum(int[] iArr) {
        if (iArr == null || WEIGHT_FACTORS.length != iArr.length) {
            return 0;
        }
        int iSum = 0;
        for (int i = 0; i < iArr.length; ++i) {
            for (int j = 0; j < WEIGHT_FACTORS.length; ++j) {
                if (i != j) continue;
                iSum += iArr[i] * WEIGHT_FACTORS[j];
            }
        }
        return iSum;
    }

    private static String getCheckCode18(int iSum) {
        String sCode = "";
        switch (iSum % 11) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "x";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
            }
        }
        return sCode;
    }

    public static String getBirthdayByCardNo(String cardNo) {
        if (cardNo == null) {
            return null;
        }
        int len = cardNo.length();
        if (len != 15 && len != 18) {
            return null;
        }
        if (len == 15) {
            cardNo = IdCardUtil.convert15To18(cardNo);
        }
        return cardNo.substring(6, 14);
    }

    public static String getGenderByCardNo(String cardNo) {
        String sCardNum;
        String sGender = "U";
        if (cardNo == null) {
            return sGender;
        }
        if (Arrays.binarySearch(new long[]{8L, 9L, 10L}, (long)cardNo.length()) >= 0) {
            if (cardNo.matches("^[a-zA-Z][0-9]{9}$")) {
                String char2 = cardNo.substring(1, 2);
                if (char2.equals("1")) {
                    sGender = "M";
                } else if (char2.equals("2")) {
                    sGender = "F";
                }
            }
            return sGender;
        }
        if (cardNo.length() != 15 && cardNo.length() != 18) {
            return sGender;
        }
        if (cardNo.length() == 15) {
            cardNo = IdCardUtil.convert15To18(cardNo);
        }
        sGender = Integer.parseInt(sCardNum = cardNo.substring(16, 17)) % 2 != 0 ? "M" : "F";
        return sGender;
    }

    public static String getProvinceByCardNo(String cardNo) {
        if (cardNo == null) {
            return null;
        }
        int len = cardNo.length();
        String sProvince = null;
        String sProvinceCode = "";
        if (len == 15 || len == 18) {
            sProvinceCode = cardNo.substring(0, 2);
        }
        sProvince = cityCodes.get(sProvinceCode);
        return sProvince;
    }

    private static boolean isNum(String val) {
        return val == null || "".equals(val) ? false : val.matches("^[0-9]*$");
    }

    static {
        cityCodes.put("11", "\u5317\u4eac\u5e02");
        cityCodes.put("12", "\u5929\u6d25\u5e02");
        cityCodes.put("13", "\u6cb3\u5317\u7701");
        cityCodes.put("14", "\u5c71\u897f\u7701");
        cityCodes.put("15", "\u5185\u8499\u53e4\u81ea\u6cbb\u533a");
        cityCodes.put("21", "\u8fbd\u5b81\u7701");
        cityCodes.put("22", "\u5409\u6797\u7701");
        cityCodes.put("23", "\u9ed1\u9f99\u6c5f\u7701");
        cityCodes.put("31", "\u4e0a\u6d77\u5e02");
        cityCodes.put("32", "\u6c5f\u82cf\u7701");
        cityCodes.put("33", "\u6d59\u6c5f\u7701");
        cityCodes.put("34", "\u5b89\u5fbd\u7701");
        cityCodes.put("35", "\u798f\u5efa\u7701");
        cityCodes.put("36", "\u6c5f\u897f\u7701");
        cityCodes.put("37", "\u5c71\u4e1c\u7701");
        cityCodes.put("41", "\u6cb3\u5357\u7701");
        cityCodes.put("42", "\u6e56\u5317\u7701");
        cityCodes.put("43", "\u6e56\u5357\u7701");
        cityCodes.put("44", "\u5e7f\u4e1c\u7701");
        cityCodes.put("45", "\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a");
        cityCodes.put("46", "\u6d77\u5357\u7701");
        cityCodes.put("50", "\u91cd\u5e86\u5e02");
        cityCodes.put("51", "\u56db\u5ddd\u7701");
        cityCodes.put("52", "\u8d35\u5dde\u7701");
        cityCodes.put("53", "\u4e91\u5357\u7701");
        cityCodes.put("54", "\u897f\u85cf\u81ea\u6cbb\u533a");
        cityCodes.put("61", "\u9655\u897f\u7701");
        cityCodes.put("62", "\u7518\u8083\u7701");
        cityCodes.put("63", "\u9752\u6d77\u7701");
        cityCodes.put("64", "\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a");
        cityCodes.put("65", "\u65b0\u7586\u7ef4\u543e\u5c14\u65cf\u81ea\u6cbb\u533a");
        cityCodes.put("71", "\u53f0\u6e7e");
        cityCodes.put("81", "\u9999\u6e2f");
        cityCodes.put("82", "\u6fb3\u95e8");
        cityCodes.put("91", "\u56fd\u5916");
        twFirstCode.put("A", 10);
        twFirstCode.put("B", 11);
        twFirstCode.put("C", 12);
        twFirstCode.put("D", 13);
        twFirstCode.put("E", 14);
        twFirstCode.put("F", 15);
        twFirstCode.put("G", 16);
        twFirstCode.put("H", 17);
        twFirstCode.put("J", 18);
        twFirstCode.put("K", 19);
        twFirstCode.put("L", 20);
        twFirstCode.put("M", 21);
        twFirstCode.put("N", 22);
        twFirstCode.put("P", 23);
        twFirstCode.put("Q", 24);
        twFirstCode.put("R", 25);
        twFirstCode.put("S", 26);
        twFirstCode.put("T", 27);
        twFirstCode.put("U", 28);
        twFirstCode.put("V", 29);
        twFirstCode.put("X", 30);
        twFirstCode.put("Y", 31);
        twFirstCode.put("W", 32);
        twFirstCode.put("Z", 33);
        twFirstCode.put("I", 34);
        twFirstCode.put("O", 35);
        hkFirstCode.put("A", 1);
        hkFirstCode.put("B", 2);
        hkFirstCode.put("C", 3);
        hkFirstCode.put("R", 18);
        hkFirstCode.put("U", 21);
        hkFirstCode.put("Z", 26);
        hkFirstCode.put("X", 24);
        hkFirstCode.put("W", 23);
        hkFirstCode.put("O", 15);
        hkFirstCode.put("N", 14);
    }
}

