/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Random;
import java.util.UUID;

public class IdWorker {
    private static final long twepoch = 1288834974657L;
    private static final long workerIdBits = 5L;
    private static final long dataCenterIdBits = 5L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long dataCenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private long workerId = IdWorker.getMachineId();
    private long dataCenterId = IdWorker.getMachineId();
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    private IdWorker() {
    }

    public static IdWorker create() {
        return new IdWorker();
    }

    public static String getUuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        return IdWorker.getRandomString(base, length);
    }

    public static String getRandomString(String base, int length) {
        Random random = new Random();
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            builder.append(base.charAt(number));
        }
        return builder.toString();
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tillNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1288834974657L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tillNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    private static long getMachineId() {
        long machineId = 0L;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses;
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp() || !(addresses = networkInterface.getInetAddresses()).hasMoreElements()) continue;
                String ipAddress = addresses.nextElement().getHostAddress();
                machineId = Math.abs(ipAddress.hashCode() % 32);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return machineId;
    }
}

