/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public abstract class JsonUtil {
    public static <T> T toBean(String text, Class<?> clz) {
        return (T)JSONObject.parseObject((String)text, clz);
    }

    public static <T> List<T> toBeanList(String text, Class<?> clz) {
        return JSONObject.parseArray((String)text, clz);
    }

    public static String toJson(Object obj) {
        return JSONObject.toJSONString((Object)obj);
    }

    public static <T> String toJson(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "[]";
        }
        return JSONObject.toJSONString(list);
    }

    public static boolean isJson(String text) {
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)text);
            return jsonObject != null;
        }
        catch (Exception e) {
            try {
                JSONArray array = JSONObject.parseArray((String)text);
                return array != null;
            }
            catch (Exception e1) {
                return false;
            }
        }
    }

    public static <K, V, T> T mapToObject(Map<K, V> map, Class<T> clz) {
        return JsonUtil.toBean(JsonUtil.toJson(map), clz);
    }

    public static <K, V, T> Map<K, V> objectToMap(T t) {
        return (Map)JsonUtil.toBean(JsonUtil.toJson(t), Map.class);
    }
}

