/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import java.math.BigDecimal;

public abstract class MathUtil {
    private static final int DEFAULT_DIV_SCALE = 2;
    private static final double EARTH_RADIUS = 6378.137;

    public static int ceil(double d) {
        BigDecimal i0;
        int i = (int)d;
        BigDecimal d0 = new BigDecimal(Double.toString(d));
        return d0.compareTo(i0 = new BigDecimal(Double.toString(i))) == 0 ? i : i + 1;
    }

    public static double add(double ... params) {
        if (params == null || params.length < 2) {
            throw new RuntimeException("The number of params can not be less then two.");
        }
        BigDecimal b = new BigDecimal("0");
        for (double num : params) {
            b = b.add(new BigDecimal(Double.toString(num)));
        }
        return b.doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double ... params) {
        if (params == null || params.length < 2) {
            throw new RuntimeException("The number of params can not be less then two.");
        }
        BigDecimal b = new BigDecimal("1");
        for (double num : params) {
            b = b.multiply(new BigDecimal(Double.toString(num)));
        }
        return b.doubleValue();
    }

    public static double div(double v1, double v2) {
        return MathUtil.div(v1, v2, 2);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero.");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static int genRandNumber(int min, int max) {
        if (min > max) {
            throw new RuntimeException("[min] can not be larger than [max].");
        }
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static double rad(double degree) {
        return MathUtil.mul(Math.PI, degree, 0.005555555555555556);
    }

    public static double getDistance(double lon1, double lat1, double lon2, double lat2) {
        double radLat1 = MathUtil.rad(lat1);
        double radLat2 = MathUtil.rad(lat2);
        double a = MathUtil.sub(radLat1, radLat2);
        double b = MathUtil.sub(MathUtil.rad(lon1), MathUtil.rad(lon2));
        double distance = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        distance = MathUtil.mul(6378.137, distance);
        distance = MathUtil.div(distance, 1.0, 3);
        return distance;
    }
}

