/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core;

import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SpringContext
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringContext.class);
    private static final String DEFAULT_INIT_METHOD = "init";
    private static final String DEFAULT_DESTROY_METHOD = "destroy";
    private static ConfigurableApplicationContext applicationContext;

    private SpringContext() {
    }

    public static <T> void registerBean(String beanName, Class<T> clz) {
        SpringContext.registerBean(beanName, clz, null);
    }

    public static <T> void registerBean(String beanName, Class<T> clz, List<Property> constructorArgList) {
        SpringContext.registerBean(beanName, clz, null, null);
    }

    public static <T> void registerBean(String beanName, Class<T> clz, List<Property> constructorArgList, List<Property> propertyList) {
        SpringContext.registerBean(beanName, clz, constructorArgList, propertyList, null, null);
    }

    public static <T> void registerBean(String beanName, Class<T> clz, List<Property> constructorArgList, List<Property> propertyList, String initMethod, String destroyMethod) {
        BeanDefinitionRegistry beanDefRegistry = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(clz);
        if (!CollectionUtils.isEmpty(constructorArgList)) {
            for (Property constructorArg : constructorArgList) {
                if (0 == constructorArg.getType()) {
                    builder.addConstructorArgValue(constructorArg.getValue());
                    continue;
                }
                if (1 == constructorArg.getType()) {
                    builder.addConstructorArgReference(constructorArg.getValue().toString());
                    continue;
                }
                throw new RuntimeException("Error parameter [type] in constructorArgList!");
            }
        }
        if (!CollectionUtils.isEmpty(propertyList)) {
            for (Property prop : propertyList) {
                if (0 == prop.getType()) {
                    builder.addPropertyValue(prop.getPropertyName(), prop.getValue());
                    continue;
                }
                if (1 == prop.getType()) {
                    builder.addPropertyReference(prop.getPropertyName(), prop.getValue().toString());
                    continue;
                }
                throw new RuntimeException("Error parameter [type] in propertyList!");
            }
        }
        if (!StringUtils.isEmpty((Object)initMethod)) {
            builder.setInitMethodName(initMethod);
        } else {
            try {
                Method defaultInitMethod = clz.getMethod(DEFAULT_INIT_METHOD, new Class[0]);
                if (defaultInitMethod != null) {
                    builder.setInitMethodName(defaultInitMethod.getName());
                }
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.warn(e.toString());
            }
        }
        if (!StringUtils.isEmpty((Object)destroyMethod)) {
            builder.setDestroyMethodName(destroyMethod);
        } else {
            try {
                Method defaultDestroyMethod = clz.getMethod(DEFAULT_DESTROY_METHOD, new Class[0]);
                if (defaultDestroyMethod != null) {
                    builder.setDestroyMethodName(defaultDestroyMethod.getName());
                }
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.warn(e.toString());
            }
        }
        beanDefRegistry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }

    public static <T> T getBean(String beanName) {
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> T getBeanIgnoreNull(String beanName) {
        try {
            return (T)applicationContext.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static <T> T getBean(Class<T> clz) {
        return (T)applicationContext.getBean(clz);
    }

    public static <T> T getBeanIgnoreNull(Class<T> clz) {
        try {
            return (T)applicationContext.getBean(clz);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static <T> T getBean(String name, Class<T> clz) {
        return (T)applicationContext.getBean(name, clz);
    }

    public static <T> T getBeanIgnoreNull(String name, Class<T> clz) {
        try {
            return (T)applicationContext.getBean(name, clz);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public void setApplicationContext(ApplicationContext ctx) {
        applicationContext = (ConfigurableApplicationContext)ctx;
    }

    public static class Property {
        private String propertyName;
        private Object value;
        private byte type;
        public static final byte TYPE_VALUE = 0;
        public static final byte TYPE_REFERENCE = 1;

        public Property() {
        }

        public Property(String propertyName, Object value, byte type) {
            this.propertyName = propertyName;
            this.value = value;
            this.type = type;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public byte getType() {
            return this.type;
        }

        public void setType(byte type) {
            this.type = type;
        }
    }
}

