/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.csv;

import com.assist4j.core.csv.CsvKey;
import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class CsvUtil {
    private static final Logger log = LoggerFactory.getLogger(CsvUtil.class);

    public static <T> byte[] export(List<T> dataList) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CsvUtil.export(out, dataList);
        byte[] data = out.toByteArray();
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void export(OutputStream out, List<T> dataList) {
        Assert.notEmpty(dataList, (String)"[dataList] must not be empty.");
        log.info("list size: {}", (Object)dataList.size());
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            osw = new OutputStreamWriter(out, "utf-8");
            bw = new BufferedWriter(osw);
            List<String> headList = CsvUtil.getOutputHeadList(dataList.get(0));
            for (String head : headList) {
                bw.append(head).append(",");
            }
            bw.newLine();
            List<String> keyList = CsvUtil.getOutputKeyList(dataList.get(0));
            for (T t : dataList) {
                List<Object> dList = CsvUtil.getOutputDataList(keyList, t);
                for (Object d : dList) {
                    bw.append(CsvUtil.convertToString(d)).append(",");
                }
                bw.newLine();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    private static <T> List<String> getOutputHeadList(T t) {
        ArrayList<String> list;
        block3: {
            block2: {
                list = new ArrayList<String>();
                if (!Map.class.isAssignableFrom(t.getClass())) break block2;
                Map map = (Map)t;
                Iterator itr = map.keySet().iterator();
                while (itr.hasNext()) {
                    list.add(itr.next().toString());
                }
                break block3;
            }
            Field[] fields = t.getClass().getDeclaredFields();
            if (fields == null || fields.length <= 0) break block3;
            for (Field field : fields) {
                CsvKey csvKeyAno = field.getAnnotation(CsvKey.class);
                if (csvKeyAno == null) continue;
                list.add(csvKeyAno.value() == null || "".equals(csvKeyAno.value().trim()) ? field.getName() : csvKeyAno.value());
            }
        }
        return list;
    }

    private static <T> List<String> getOutputKeyList(T t) {
        ArrayList<String> list;
        block3: {
            block2: {
                list = new ArrayList<String>();
                if (!Map.class.isAssignableFrom(t.getClass())) break block2;
                Map map = (Map)t;
                Iterator itr = map.keySet().iterator();
                while (itr.hasNext()) {
                    list.add(itr.next().toString());
                }
                break block3;
            }
            Field[] fields = t.getClass().getDeclaredFields();
            if (fields == null || fields.length <= 0) break block3;
            for (Field field : fields) {
                CsvKey csvKeyAno = field.getAnnotation(CsvKey.class);
                if (csvKeyAno == null) continue;
                list.add(field.getName());
            }
        }
        return list;
    }

    private static <T> List<Object> getOutputDataList(List<String> keyList, T t) {
        Assert.notEmpty(keyList, (String)"[keyList] must not be empty.");
        ArrayList<Object> list = new ArrayList<Object>();
        if (Map.class.isAssignableFrom(t.getClass())) {
            Map map = (Map)t;
            for (String key : keyList) {
                list.add(map.get(key));
            }
        } else {
            for (String key : keyList) {
                PropertyDescriptor pd = null;
                try {
                    pd = new PropertyDescriptor(key, t.getClass());
                    Method getMethod = pd.getReadMethod();
                    Object o = getMethod.invoke(t, new Object[0]);
                    list.add(o);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        return list;
    }

    private static String convertToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value);
        }
        return value.toString();
    }
}

