/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.encrypt;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class DSACoder {
    public static final String ALGORITHM = "DSA";
    private static final int KEY_SIZE = 1024;
    private static final String PUBLIC_KEY = "DSAPublicKey";
    private static final String PRIVATE_KEY = "DSAPrivateKey";

    public static Map<String, String> initKey() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(UUID.randomUUID().toString().replace("-", "").getBytes());
        KeyPairGenerator keygen = KeyPairGenerator.getInstance(ALGORITHM);
        keygen.initialize(1024, secureRandom);
        KeyPair kPair = keygen.genKeyPair();
        PublicKey publicKey = kPair.getPublic();
        PrivateKey privateKey = kPair.getPrivate();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(PUBLIC_KEY, DSACoder.byte2HexStr(publicKey.getEncoded()));
        map.put(PRIVATE_KEY, DSACoder.byte2HexStr(privateKey.getEncoded()));
        return map;
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(DSACoder.hexStr2Byte(privateKey));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(spec);
        Signature signature = Signature.getInstance(keyFactory.getAlgorithm());
        signature.initSign(priKey);
        signature.update(data);
        return DSACoder.byte2HexStr(signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(DSACoder.hexStr2Byte(publicKey));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(keyFactory.getAlgorithm());
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(DSACoder.hexStr2Byte(sign));
    }

    private static String getPrivateKey(Map<String, String> keyMap) {
        return keyMap.get(PRIVATE_KEY);
    }

    private static String getPublicKey(Map<String, String> keyMap) {
        return keyMap.get(PUBLIC_KEY);
    }

    private static String byte2HexStr(byte[] value) {
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < value.length; ++i) {
            String hex = Integer.toHexString(value[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            builder.append(hex.toLowerCase());
        }
        return builder.toString();
    }

    private static byte[] hexStr2Byte(String value) {
        if (value.length() < 1) {
            return null;
        }
        byte[] result = new byte[value.length() / 2];
        for (int i = 0; i < value.length() / 2; ++i) {
            int high = Integer.parseInt(value.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(value.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static void main(String ... args) throws Exception {
        String inputStr = "yuweitest";
        byte[] data = inputStr.getBytes();
        Map<String, String> keyMap = DSACoder.initKey();
        String publicKey = DSACoder.getPublicKey(keyMap);
        String privateKey = DSACoder.getPrivateKey(keyMap);
        System.out.println("\u516c\u94a5: " + publicKey);
        System.out.println("\u79c1\u94a5: " + privateKey);
        String sign = DSACoder.sign(data, privateKey);
        System.out.println("\u7b7e\u540d: " + sign);
        boolean status = DSACoder.verify(data, publicKey, sign);
        System.out.println("\u72b6\u6001: " + status);
    }
}

