/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.encrypt;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class RSACoder {
    public static final String ALGORITHM = "RSA";
    private static final int KEY_SIZE = 1024;
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";

    public static Map<String, String> initKey() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(UUID.randomUUID().toString().replace("-", "").getBytes());
        KeyPairGenerator keygen = KeyPairGenerator.getInstance(ALGORITHM);
        keygen.initialize(1024, secureRandom);
        KeyPair kPair = keygen.genKeyPair();
        PublicKey publicKey = kPair.getPublic();
        PrivateKey privateKey = kPair.getPrivate();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(PUBLIC_KEY, RSACoder.byte2HexStr(publicKey.getEncoded()));
        map.put(PRIVATE_KEY, RSACoder.byte2HexStr(privateKey.getEncoded()));
        return map;
    }

    private static String getPrivateKey(Map<String, String> keyMap) {
        return keyMap.get(PRIVATE_KEY);
    }

    private static String getPublicKey(Map<String, String> keyMap) {
        return keyMap.get(PUBLIC_KEY);
    }

    public static String encrypt(String str, String publicKey) throws Exception {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(RSACoder.hexStr2Byte(publicKey));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        RSAPublicKey pubKey = (RSAPublicKey)keyFactory.generatePublic(spec);
        BigInteger e = pubKey.getPublicExponent();
        BigInteger n = pubKey.getModulus();
        byte[] ptext = str.getBytes("utf-8");
        BigInteger m = new BigInteger(ptext);
        BigInteger c = m.modPow(e, n);
        return c.toString();
    }

    public static String decrypt(String str, String privateKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(RSACoder.hexStr2Byte(privateKey));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        RSAPrivateKey priKey = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        BigInteger c = new BigInteger(str);
        BigInteger d = priKey.getPrivateExponent();
        BigInteger n = priKey.getModulus();
        BigInteger m = c.modPow(d, n);
        byte[] mt = m.toByteArray();
        return new String(mt, "utf-8");
    }

    private static String byte2HexStr(byte[] value) {
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < value.length; ++i) {
            String hex = Integer.toHexString(value[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            builder.append(hex.toLowerCase());
        }
        return builder.toString();
    }

    private static byte[] hexStr2Byte(String value) {
        if (value.length() < 1) {
            return null;
        }
        byte[] result = new byte[value.length() / 2];
        for (int i = 0; i < value.length() / 2; ++i) {
            int high = Integer.parseInt(value.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(value.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> keyMap = RSACoder.initKey();
        String publicKey = RSACoder.getPublicKey(keyMap);
        String privateKey = RSACoder.getPrivateKey(keyMap);
        String str1 = "RSA\u52a0\u89e3\u5bc6\u6d4b\u8bd5\uff01";
        String str2 = RSACoder.encrypt(str1, publicKey);
        String str3 = RSACoder.decrypt(str2, privateKey);
        System.out.println("\u516c\u94a5\uff1a " + publicKey);
        System.out.println("\u79c1\u94a5\uff1a " + privateKey);
        System.out.println("\u539f\u6587\uff1a " + str1);
        System.out.println("\u5bc6\u6587\uff1a " + str2);
        System.out.println("\u89e3\u5bc6\uff1a " + str3);
    }
}

