/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.encrypt;

import com.assist4j.core.encrypt.Algor;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class SecurityUtil {
    private static final String SECURITY_KEY = "sfdfyu8**((^$$$SDSDhHJlSDDsdsvcx234ex,,,cjv.xckv...";
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String getMd5(String str) {
        return SecurityUtil.getMd5(str, "utf-8");
    }

    public static final String getMd5(String str, String charset) {
        return SecurityUtil.getSecurityByAlgor(Algor.MD5.getCode(), str, charset);
    }

    public static final String getSha1(String str) {
        return SecurityUtil.getSha1(str, "utf-8");
    }

    public static final String getSha1(String str, String charset) {
        return SecurityUtil.getSecurityByAlgor(Algor.SHA1.getCode(), str, charset);
    }

    public static String getSecurityByAlgor(String algor, String str, String charset) {
        try {
            byte[] tmp = str.getBytes(charset == null ? "utf-8" : charset);
            MessageDigest mdTemp = MessageDigest.getInstance(algor);
            mdTemp.update(tmp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] arr = new char[j << 1];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                arr[k++] = HEX_DIGIT[byte0 >>> 4 & 0xF];
                arr[k++] = HEX_DIGIT[byte0 & 0xF];
            }
            return new String(arr).toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encode(String str) {
        if (str == null) {
            return null;
        }
        String str0 = SecurityUtil.encrypt(str);
        String ori = str0 + "," + SecurityUtil.getMd5(SECURITY_KEY);
        String secr = SecurityUtil.getMd5(ori);
        return SecurityUtil.encrypt(str0 + "," + secr);
    }

    public static String decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            String[] arr = new String(SecurityUtil.decrypt(str)).split(",");
            if (arr == null || arr.length != 2) {
                return null;
            }
            if (arr[1].equals(SecurityUtil.getMd5(arr[0] + "," + SecurityUtil.getMd5(SECURITY_KEY)))) {
                return new String(SecurityUtil.decrypt(arr[0]));
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String encrypt(String word) {
        try {
            Cipher encrypt = Cipher.getInstance(Algor.DES.getCode());
            encrypt.init(1, SecurityUtil.buildDESKey(SecurityUtil.getMd5(SECURITY_KEY)));
            return SecurityUtil.bytesToHexStr(encrypt.doFinal(word.getBytes("utf-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String decrypt(String word) {
        try {
            Cipher decrypt = Cipher.getInstance(Algor.DES.getCode());
            decrypt.init(2, SecurityUtil.buildDESKey(SecurityUtil.getMd5(SECURITY_KEY)));
            return new String(decrypt.doFinal(SecurityUtil.hexStrToBytes(word)), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SecretKey buildDESKey(String value) throws UnsupportedEncodingException {
        byte[] bval = value.getBytes("utf-8");
        byte[] bt = new byte[8];
        for (int i = 0; i < bt.length && i < bval.length; ++i) {
            bt[i] = bval[i];
        }
        return new SecretKeySpec(bt, Algor.DES.getCode());
    }

    public static byte[] hexStrToBytes(String value) {
        if (value.length() < 1) {
            return null;
        }
        byte[] result = new byte[value.length() / 2];
        for (int i = 0; i < value.length() / 2; ++i) {
            int high = Integer.parseInt(value.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(value.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static String bytesToHexStr(byte[] value) {
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < value.length; ++i) {
            String hex = Integer.toHexString(value[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            builder.append(hex.toLowerCase());
        }
        return builder.toString();
    }
}

