/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.exception;

import com.alibaba.fastjson.support.spring.FastJsonJsonView;
import com.assist4j.core.InterceptorUtil;
import com.assist4j.core.JsonUtil;
import com.assist4j.core.Response;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ExceptionHandler
implements HandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);
    private String errorPage;
    private Map<Class<?>, String> errorMsgMap;

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public void setErrorMsgMap(Map<Class<?>, String> errorMsgMap) {
        this.errorMsgMap = errorMsgMap;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        log.error("", (Throwable)ex);
        if (InterceptorUtil.hasResponseBodyAnnotation(handler) || this.errorPage == null) {
            return this.createJsonView(ex);
        }
        return this.createModelAndView(ex);
    }

    private ModelAndView createJsonView(Exception ex) {
        FastJsonJsonView view = new FastJsonJsonView();
        Map attributes = JsonUtil.objectToMap(new Response("9999", this.showMessage(ex)));
        view.setAttributesMap(attributes);
        return new ModelAndView((View)view);
    }

    private ModelAndView createModelAndView(Exception ex) {
        ModelAndView mv = new ModelAndView(this.errorPage);
        mv.getModel().put("status", 500);
        mv.getModel().put("errorMsg", this.showMessage(ex));
        return mv;
    }

    private String showMessage(Exception ex) {
        String msg = null;
        if (this.errorMsgMap != null) {
            msg = this.errorMsgMap.get(ex.getClass());
        }
        if (msg != null && !"".equals(msg)) {
            return msg;
        }
        msg = ex.getMessage();
        if (msg != null && !"".equals(msg)) {
            return msg;
        }
        return ex.getClass().getName();
    }
}

