/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.geo;

import com.assist4j.core.MathUtil;
import com.assist4j.core.geo.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GeoHash {
    private Location location;
    public static final int DEFAULT_HASH_LENGTH = 10;
    private int latLength = 25;
    private int lngLength = 25;
    private double minLat;
    private double minLng;
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public GeoHash(double lat, double lng) {
        this(10, lat, lng);
    }

    private GeoHash(int hashLength, double lat, double lng) {
        this.setHashLength(hashLength);
        this.location = new Location(lat, lng);
        this.setMinLatLng();
    }

    private void setMinLatLng() {
        int i;
        this.minLat = 180.0;
        for (i = 0; i < this.latLength; ++i) {
            this.minLat = MathUtil.mul(this.minLat, 0.5);
        }
        this.minLng = 360.0;
        for (i = 0; i < this.lngLength; ++i) {
            this.minLng = MathUtil.mul(this.minLng, 0.5);
        }
    }

    public List<String> getGeoHashBase32For9() {
        String rightDown;
        String rightMid;
        String rightUp;
        String midDown;
        String midMid;
        String midUp;
        String leftDown;
        String leftMid;
        double leftLat = MathUtil.sub(this.location.getLat(), this.minLat);
        double rightLat = MathUtil.add(this.location.getLat(), this.minLat);
        double upLng = MathUtil.sub(this.location.getLng(), this.minLng);
        double downLng = MathUtil.add(this.location.getLng(), this.minLng);
        ArrayList<String> base32For9 = new ArrayList<String>();
        String leftUp = this.getGeoHashBase32(leftLat, upLng);
        if (leftUp != null && !"".equals(leftUp)) {
            base32For9.add(leftUp);
        }
        if ((leftMid = this.getGeoHashBase32(leftLat, this.location.getLng())) != null && !"".equals(leftMid)) {
            base32For9.add(leftMid);
        }
        if ((leftDown = this.getGeoHashBase32(leftLat, downLng)) != null && !"".equals(leftDown)) {
            base32For9.add(leftDown);
        }
        if ((midUp = this.getGeoHashBase32(this.location.getLat(), upLng)) != null && !"".equals(midUp)) {
            base32For9.add(midUp);
        }
        if ((midMid = this.getGeoHashBase32(this.location.getLat(), this.location.getLng())) != null && !"".equals(midMid)) {
            base32For9.add(midMid);
        }
        if ((midDown = this.getGeoHashBase32(this.location.getLat(), downLng)) != null && !"".equals(midDown)) {
            base32For9.add(midDown);
        }
        if ((rightUp = this.getGeoHashBase32(rightLat, upLng)) != null && !"".equals(rightUp)) {
            base32For9.add(rightUp);
        }
        if ((rightMid = this.getGeoHashBase32(rightLat, this.location.getLng())) != null && !"".equals(rightMid)) {
            base32For9.add(rightMid);
        }
        if ((rightDown = this.getGeoHashBase32(rightLat, downLng)) != null && !"".equals(rightDown)) {
            base32For9.add(rightDown);
        }
        return base32For9;
    }

    private boolean setHashLength(int length) {
        if (length < 1) {
            return false;
        }
        this.latLength = length * 5 / 2;
        this.lngLength = length % 2 == 0 ? this.latLength : this.latLength + 1;
        this.setMinLatLng();
        return true;
    }

    public String getGeoHashBase32() {
        return this.getGeoHashBase32(this.location.getLat(), this.location.getLng());
    }

    private String getGeoHashBase32(double lat, double lng) {
        boolean[] bools = this.getGeoBinary(lat, lng);
        if (bools == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < bools.length; i += 5) {
            boolean[] base32 = new boolean[5];
            for (int j = 0; j < 5; ++j) {
                base32[j] = bools[i + j];
            }
            char cha = this.getBase32Char(base32);
            if (' ' == cha) {
                return null;
            }
            builder.append(cha);
        }
        return builder.toString();
    }

    private char getBase32Char(boolean[] base32) {
        if (base32 == null || base32.length != 5) {
            return ' ';
        }
        int num = 0;
        for (boolean bool : base32) {
            num <<= 1;
            if (!bool) continue;
            ++num;
        }
        return CHARS[num % CHARS.length];
    }

    private boolean[] getGeoBinary(double lat, double lng) {
        boolean[] latArray = this.getHashArray(lat, -90.0, 90.0, this.latLength);
        boolean[] lngArray = this.getHashArray(lng, -180.0, 180.0, this.lngLength);
        return this.merge(latArray, lngArray);
    }

    private boolean[] merge(boolean[] latArray, boolean[] lngArray) {
        int i;
        if (latArray == null || lngArray == null) {
            return null;
        }
        boolean[] result = new boolean[lngArray.length + latArray.length];
        Arrays.fill(result, false);
        for (i = 0; i < lngArray.length; ++i) {
            result[2 * i] = lngArray[i];
        }
        for (i = 0; i < latArray.length; ++i) {
            result[2 * i + 1] = latArray[i];
        }
        return result;
    }

    private boolean[] getHashArray(double value, double min, double max, int length) {
        if (value < min || value > max) {
            return null;
        }
        if (length < 1) {
            return null;
        }
        boolean[] result = new boolean[length];
        for (int i = 0; i < length; ++i) {
            double[] dArray = new double[]{MathUtil.add(min, max), 0.5};
            double mid = MathUtil.mul(dArray);
            if (value > mid) {
                result[i] = true;
                min = mid;
                continue;
            }
            result[i] = false;
            max = mid;
        }
        return result;
    }
}

