/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.io;

import com.assist4j.core.DateUtil;
import com.assist4j.core.io.StreamUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUtil
extends StreamUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static String getContentFromFile(String filePath) {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader bf = null;
        try {
            String line;
            fis = new FileInputStream(filePath);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            bf = new BufferedReader(isr);
            StringBuilder builder = new StringBuilder("");
            do {
                if ((line = bf.readLine()) == null) continue;
                if (builder.length() != 0) {
                    builder.append("\n");
                }
                builder.append(line);
            } while (line != null);
            String string = builder.toString();
            return string;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String write(byte[] content, String rootDir, String subDir, String fileName) {
        subDir = subDir == null || subDir.trim().equals("") ? "" : subDir.trim();
        String dateDir = DateUtil.formatDate(new Date(), "yyyy/MM/dd");
        subDir = subDir + "/" + dateDir;
        FileUtil.write(content, rootDir + subDir + "/" + fileName);
        return subDir + "/" + fileName;
    }

    public static void write(byte[] content, String fullFileName) {
        File file = new File(fullFileName);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream fos = null;
        OutputStream bos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(content);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    ((OutputStream)fos).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

