/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.io;

import com.assist4j.core.io.FileUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageFileUtil
extends FileUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] imgData, int newWidth) {
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imgData);
            BufferedImage oldImage = ImageIO.read(inputStream);
            int oldWidth = oldImage.getWidth(null);
            int oldHeight = oldImage.getHeight(null);
            if (newWidth > oldWidth) {
                newWidth = oldWidth;
            }
            Image resizedImage = null;
            resizedImage = oldWidth > oldHeight ? oldImage.getScaledInstance(newWidth, newWidth * oldHeight / oldWidth, 4) : oldImage.getScaledInstance(newWidth * oldWidth / oldHeight, newWidth, 4);
            Image temp = new ImageIcon(resizedImage).getImage();
            BufferedImage bufferedImage = new BufferedImage(temp.getWidth(null), temp.getHeight(null), 1);
            Graphics2D g = bufferedImage.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, temp.getWidth(null), temp.getHeight(null));
            g.drawImage(temp, 0, 0, null);
            g.dispose();
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, ImageFileUtil.getImageType(imgData), outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] merge(byte[] bgImgData, byte[] imgData, int x, int y, int width, int height) {
        ByteArrayInputStream bgImgStream = null;
        ByteArrayInputStream imgStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            bgImgStream = new ByteArrayInputStream(bgImgData);
            imgStream = new ByteArrayInputStream(imgData);
            BufferedImage bg = ImageIO.read(bgImgStream);
            BufferedImage image = ImageIO.read(imgStream);
            Graphics2D g = bg.createGraphics();
            g.drawImage(image, x, y, width, height, null);
            g.dispose();
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bg, ImageFileUtil.getImageType(bgImgData), outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (imgStream != null) {
                try {
                    imgStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bgImgStream != null) {
                try {
                    bgImgStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageType(byte[] imgData) {
        ByteArrayInputStream inputStream = null;
        ImageInputStream imageInputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imgData);
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            ImageReader imageReader = ImageIO.getImageReaders(imageInputStream).next();
            String string = imageReader.getFormatName();
            return string;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] cut(byte[] imgData, int x, int y, int width, int height) {
        ByteArrayInputStream inputStream = null;
        ImageInputStream imageInputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imgData);
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            ImageReader imageReader = ImageIO.getImageReaders(imageInputStream).next();
            imageReader.setInput(imageInputStream, true);
            ImageReadParam param = imageReader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, width, height);
            param.setSourceRegion(rect);
            BufferedImage image = imageReader.read(0, param);
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, imageReader.getFormatName(), outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] rotate(byte[] imgData, int degree) {
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imgData);
            BufferedImage image = ImageIO.read(inputStream);
            int w = image.getWidth();
            int h = image.getHeight();
            int type = image.getColorModel().getTransparency();
            BufferedImage img = new BufferedImage(w, h, type);
            Graphics2D graph = img.createGraphics();
            graph.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graph.rotate(Math.toRadians(degree), w / 2, h / 2);
            graph.drawImage((Image)image, 0, 0, null);
            graph.dispose();
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, ImageFileUtil.getImageType(imgData), outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

