/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.io;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public abstract class QrCodeUtil {
    private static final String CHARSET = "utf-8";
    private static final String DEFAULT_IMAGE_TYPE = "jpg";
    private static final int QRCODE_SIZE = 300;
    private static final int WIDTH = 60;
    private static final int HEIGHT = 60;

    private static BufferedImage createImage(String content, int qrcodeSize, ErrorCorrectionLevel ecLevel, byte[] logoData, boolean compressLogo) {
        if (qrcodeSize <= 0) {
            qrcodeSize = 300;
        }
        if (ecLevel == null) {
            ecLevel = ErrorCorrectionLevel.H;
        }
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ecLevel);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 0);
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, qrcodeSize, qrcodeSize, hints);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            BufferedImage qrcodeImg = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    qrcodeImg.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            if (logoData == null || logoData.length <= 0) {
                return qrcodeImg;
            }
            QrCodeUtil.insertLogo(qrcodeImg, logoData, compressLogo);
            return qrcodeImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertLogo(BufferedImage qrcodeImg, byte[] logoData, boolean compressLogo) {
        ByteArrayInputStream logoBais = null;
        try {
            logoBais = new ByteArrayInputStream(logoData);
            Image logoImg = ImageIO.read(logoBais);
            int width = ((Image)logoImg).getWidth(null);
            int height = ((Image)logoImg).getHeight(null);
            if (compressLogo) {
                if (width > 60) {
                    width = 60;
                }
                if (height > 60) {
                    height = 60;
                }
                Image scaledLogoImg = logoImg.getScaledInstance(width, height, 4);
                BufferedImage tag = new BufferedImage(width, height, 1);
                Graphics g = tag.getGraphics();
                g.drawImage(scaledLogoImg, 0, 0, null);
                g.dispose();
                logoImg = scaledLogoImg;
            }
            Graphics2D graph = qrcodeImg.createGraphics();
            int x = (300 - width) / 2;
            int y = (300 - height) / 2;
            graph.drawImage(logoImg, x, y, width, height, null);
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
            graph.setStroke(new BasicStroke(3.0f));
            graph.draw(shape);
            graph.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (logoBais != null) {
                try {
                    logoBais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static byte[] encode(String content) {
        return QrCodeUtil.encode(content, 0);
    }

    public static byte[] encode(String content, int qrcodeSize) {
        return QrCodeUtil.encode(content, qrcodeSize, DEFAULT_IMAGE_TYPE, null, false);
    }

    public static byte[] encode(String content, byte[] logoData) {
        return QrCodeUtil.encode(content, logoData, false);
    }

    public static byte[] encode(String content, String imgType) {
        return QrCodeUtil.encode(content, 0, imgType, null, false);
    }

    public static byte[] encode(String content, byte[] logoData, boolean compressLogo) {
        return QrCodeUtil.encode(content, 0, DEFAULT_IMAGE_TYPE, logoData, compressLogo);
    }

    public static byte[] encode(String content, String imgType, byte[] logoData, boolean compressLogo) {
        return QrCodeUtil.encode(content, 0, imgType, logoData, compressLogo);
    }

    public static byte[] encode(String content, int qrcodeSize, String imgType, byte[] logoData, boolean compressLogo) {
        return QrCodeUtil.encode(content, qrcodeSize, imgType, ErrorCorrectionLevel.H, logoData, compressLogo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(String content, int qrcodeSize, String imgType, ErrorCorrectionLevel ecLevel, byte[] logoData, boolean compressLogo) {
        BufferedImage bufImg = QrCodeUtil.createImage(content, qrcodeSize, ecLevel, logoData, compressLogo);
        ByteArrayOutputStream baos = null;
        byte[] qrcodeData = null;
        try {
            baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufImg, imgType, baos);
            qrcodeData = baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return qrcodeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decode(byte[] qrcode) {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(qrcode);
            BufferedImage image = ImageIO.read(bais);
            if (image == null) {
                String string = null;
                return string;
            }
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, CHARSET);
            Result result = new MultiFormatReader().decode(bitmap, hints);
            String string = result.getText();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

