/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public abstract class VcodeImgUtil {
    private static final String DEFAULT_IMAGE_TYPE = "jpg";

    public static final byte[] createImage(String code) {
        return VcodeImgUtil.createImage(code, DEFAULT_IMAGE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] createImage(String code, String imgType) {
        RenderedImage image = VcodeImgUtil.createImage0(code);
        ByteArrayOutputStream output = null;
        ImageOutputStream imageOut = null;
        try {
            output = new ByteArrayOutputStream();
            imageOut = ImageIO.createImageOutputStream(output);
            ImageIO.write(image, imgType, imageOut);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (imageOut != null) {
                try {
                    imageOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static RenderedImage createImage0(String code) {
        int i;
        int width = 72;
        int height = 20;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Random random = new Random();
        g.setColor(VcodeImgUtil.getRandColor(200, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.setColor(VcodeImgUtil.getRandColor(160, 200));
        for (i = 0; i < 155; ++i) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }
        for (i = 0; i < code.length(); ++i) {
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.drawString(code.substring(i, i + 1), 13 * i + 6, 16);
        }
        g.dispose();
        return image;
    }

    private static Color getRandColor(int fc, int bc) {
        int bc0;
        Random random = new Random();
        int fc0 = fc;
        if (fc0 > 255) {
            fc0 = 255;
        }
        if ((bc0 = bc) > 255) {
            bc0 = 255;
        }
        int r = fc0 + random.nextInt(bc0 - fc0);
        int g = fc0 + random.nextInt(bc0 - fc0);
        int b = fc0 + random.nextInt(bc0 - fc0);
        return new Color(r, g, b);
    }
}

