/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.mail;

import com.assist4j.core.Response;
import com.assist4j.core.mail.EmailSender;
import com.assist4j.core.mail.Mail;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmailSender
implements EmailSender<Mail> {
    private static final Logger log = LoggerFactory.getLogger(DefaultEmailSender.class);
    public String server;
    public int sslPort;
    public boolean auth;
    public String user;
    public String password;

    @Override
    public Response<Void> send(Mail mail) {
        Properties props = System.getProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.socketFactory.fallback", "false");
        props.put("mail.smtp.socketFactory.port", String.valueOf(this.sslPort));
        props.put("mail.smtp.host", this.server);
        props.put("mail.smtp.port", String.valueOf(this.sslPort));
        props.put("mail.smtp.auth", Boolean.toString(this.auth));
        props.put("mail.smtp.starttls.enable", "true");
        Session session = this.auth ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(DefaultEmailSender.this.user, DefaultEmailSender.this.password);
            }
        }) : Session.getInstance((Properties)props);
        session.setDebug(true);
        try {
            MimeMessage msg = new MimeMessage(session);
            InternetAddress address = new InternetAddress();
            address.setPersonal(mail.getSenderName(), "utf-8");
            address.setAddress(this.user);
            msg.setFrom((Address)address);
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mail.getReceiverEmail(), (boolean)false));
            msg.setSubject(mail.getTitle(), "utf-8");
            msg.setSentDate(new Date());
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mainPart = new MimeBodyPart();
            mainPart.setContent((Object)mail.getBody(), "text/html;charset=utf-8");
            mainPart.setHeader("Content-Transfer-Encoding", "base64");
            mainPart.setHeader("TextSender", mail.getSenderEmail());
            mp.addBodyPart((BodyPart)mainPart);
            if (mail.getAttachments() != null) {
                for (DataSource ds : mail.getAttachments()) {
                    MimeBodyPart attachment = new MimeBodyPart();
                    attachment.setDataHandler(new DataHandler(ds));
                    attachment.setFileName(ds.getName());
                    attachment.setHeader("Content-Transfer-Encoding", "base64");
                    mp.addBodyPart((BodyPart)attachment);
                }
            }
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
            return new Response<Void>("0000", "ok");
        }
        catch (Exception e) {
            log.error("[Error=={}, Receiver=={}]", (Object)e.getMessage(), (Object)mail.getReceiverEmail());
            log.error("", (Throwable)e);
            return new Response<Void>("9999", e.getMessage());
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public boolean getAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

