/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.mq.activemq.listener;

import com.assist4j.core.mq.activemq.message.IReceiver;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.listener.SessionAwareMessageListener;

public class TextMessageListener
implements SessionAwareMessageListener<Message> {
    private static final Logger log = LoggerFactory.getLogger(TextMessageListener.class);
    private IReceiver receiver;

    public void setReceiver(IReceiver receiver) {
        this.receiver = receiver;
    }

    public void onMessage(Message message, Session session) {
        if (this.receiver == null) {
            return;
        }
        try {
            ActiveMQTextMessage msg = (ActiveMQTextMessage)message;
            this.receiver.receive(msg.getDestination().getPhysicalName(), msg.getText());
        }
        catch (Exception e) {
            log.error("==>", (Throwable)e);
        }
    }
}

