/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.office;

import com.assist4j.core.JsonUtil;
import com.assist4j.core.office.ExcelKey;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static List<Map<String, Object>> read(byte[] fileData) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(fileData);
            Workbook wb = WorkbookFactory.create((InputStream)is);
            Sheet sheet = wb.getSheetAt(0);
            List<String> headList = ExcelUtil.getInputHeadList(sheet.getRow(0));
            List<Map<String, Object>> list = ExcelUtil.getInputDataList(sheet, headList);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    public static <T> List<T> read(byte[] fileData, Class<T> clz) {
        ArrayList<T> list = new ArrayList<T>();
        Field[] fields = clz.getDeclaredFields();
        if (fields == null || fields.length <= 0) {
            return list;
        }
        List<Map<String, Object>> mapList = ExcelUtil.read(fileData);
        if (CollectionUtils.isEmpty(mapList)) {
            return list;
        }
        for (Map<String, Object> map : mapList) {
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
            for (Field field : fields) {
                String key;
                Object v;
                ExcelKey excelKeyAno = field.getAnnotation(ExcelKey.class);
                if (excelKeyAno == null || (v = map.get(key = excelKeyAno.title() == null || "".equals(excelKeyAno.title().trim()) ? field.getName() : excelKeyAno.title().trim())) == null) continue;
                fieldValueMap.put(field.getName(), v);
            }
            T t = JsonUtil.mapToObject(fieldValueMap, clz);
            list.add(t);
        }
        return list;
    }

    public static <T> byte[] export(List<T> dataList) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ExcelUtil.export(out, dataList);
        byte[] data = out.toByteArray();
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void export(OutputStream out, List<T> dataList) {
        Assert.notEmpty(dataList, (String)"[dataList] is required.");
        log.info("list size: {}", (Object)dataList.size());
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook();
            workbook.setCompressTempFiles(true);
            CellStyle titleStyle = workbook.createCellStyle();
            titleStyle.setAlignment((short)2);
            Font titleFont = workbook.createFont();
            titleFont.setFontHeightInPoints((short)20);
            titleFont.setBoldweight((short)700);
            titleStyle.setFont(titleFont);
            SXSSFSheet sheet = workbook.createSheet();
            sheet.trackAllColumnsForAutoSizing();
            List<String> headList = ExcelUtil.getOutputHeadList(dataList.get(0));
            SXSSFRow headRow = sheet.createRow(0);
            for (int i = 0; i < headList.size(); ++i) {
                String head = headList.get(i);
                SXSSFCell cell = headRow.createCell(i);
                cell.setCellValue(head);
                cell.setCellStyle(titleStyle);
                sheet.autoSizeColumn(i, true);
            }
            List<String> keyList = ExcelUtil.getOutputKeyList(dataList.get(0));
            for (int i = 0; i < dataList.size(); ++i) {
                T t = dataList.get(i);
                SXSSFRow dataRow = sheet.createRow(i + 1);
                List<Object> dList = ExcelUtil.getOutputDataList(keyList, t);
                for (int j = 0; j < dList.size(); ++j) {
                    SXSSFCell cell = dataRow.createCell(j);
                    ExcelUtil.setCellValue((Cell)cell, dList.get(j));
                }
            }
            workbook.write(out);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    private static <T> List<String> getOutputHeadList(T t) {
        ArrayList<String> list;
        block3: {
            block2: {
                list = new ArrayList<String>();
                if (!Map.class.isAssignableFrom(t.getClass())) break block2;
                Map map = (Map)t;
                Iterator itr = map.keySet().iterator();
                while (itr.hasNext()) {
                    list.add(itr.next().toString());
                }
                break block3;
            }
            Field[] fields = t.getClass().getDeclaredFields();
            if (fields == null || fields.length <= 0) break block3;
            for (Field field : fields) {
                ExcelKey excelKeyAno = field.getAnnotation(ExcelKey.class);
                if (excelKeyAno == null) continue;
                list.add(excelKeyAno.title() == null || "".equals(excelKeyAno.title().trim()) ? field.getName() : excelKeyAno.title().trim());
            }
        }
        return list;
    }

    private static <T> List<String> getOutputKeyList(T t) {
        ArrayList<String> list;
        block3: {
            block2: {
                list = new ArrayList<String>();
                if (!Map.class.isAssignableFrom(t.getClass())) break block2;
                Map map = (Map)t;
                Iterator itr = map.keySet().iterator();
                while (itr.hasNext()) {
                    list.add(itr.next().toString());
                }
                break block3;
            }
            Field[] fields = t.getClass().getDeclaredFields();
            if (fields == null || fields.length <= 0) break block3;
            for (Field field : fields) {
                ExcelKey excelKeyAno = field.getAnnotation(ExcelKey.class);
                if (excelKeyAno == null) continue;
                list.add(field.getName());
            }
        }
        return list;
    }

    private static <T> List<Object> getOutputDataList(List<String> keyList, T t) {
        Assert.notEmpty(keyList, (String)"[keyList] is required.");
        ArrayList<Object> list = new ArrayList<Object>();
        if (Map.class.isAssignableFrom(t.getClass())) {
            Map map = (Map)t;
            for (String key : keyList) {
                list.add(map.get(key));
            }
        } else {
            for (String key : keyList) {
                PropertyDescriptor pd = null;
                try {
                    pd = new PropertyDescriptor(key, t.getClass());
                    Method getMethod = pd.getReadMethod();
                    Object o = getMethod.invoke(t, new Object[0]);
                    list.add(o);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        return list;
    }

    private static List<String> getInputHeadList(Row row) {
        ArrayList<String> list = new ArrayList<String>();
        for (Cell cell : row) {
            String head = cell.toString();
            if (head == null || "".equals(head.trim())) continue;
            list.add(head.trim());
        }
        return list;
    }

    private static List<Map<String, Object>> getInputDataList(Sheet sheet, List<String> keyList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Row row : sheet) {
            if (row.getRowNum() <= 0) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            for (Cell cell : row) {
                map.put(keyList.get(i++), ExcelUtil.getCellValue(cell));
            }
            list.add(map);
        }
        return list;
    }

    private static void setCellValue(Cell cell, Object value) {
        if (value instanceof Number) {
            cell.setCellValue(value == null ? 0.0 : Double.parseDouble(value.toString()));
        } else if (value instanceof Boolean) {
            cell.setCellValue(value == null ? false : Boolean.valueOf(value.toString()));
        } else if (value instanceof Date) {
            cell.setCellValue(value == null ? "" : new SimpleDateFormat(DEFAULT_DATE_FORMAT).format(value));
        } else {
            cell.setCellValue(value == null ? "" : value.toString());
        }
    }

    private static Object getCellValue(Cell cell) {
        int ct = cell.getCellType();
        if (0 == ct) {
            int i;
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                return cell.getDateCellValue();
            }
            double d = cell.getNumericCellValue();
            if (d == (double)(i = (int)d)) {
                return i;
            }
            return d;
        }
        if (1 == ct) {
            return cell.getRichStringCellValue().getString();
        }
        if (2 == ct) {
            Workbook wb = cell.getSheet().getWorkbook();
            CreationHelper crateHelper = wb.getCreationHelper();
            FormulaEvaluator evaluator = crateHelper.createFormulaEvaluator();
            return ExcelUtil.getCellValue(evaluator.evaluateInCell(cell));
        }
        if (3 == ct) {
            return null;
        }
        if (4 == ct) {
            return cell.getBooleanCellValue();
        }
        if (5 == ct) {
            return null;
        }
        return null;
    }
}

