/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.office;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class WordUtil {
    private static final Logger log = LoggerFactory.getLogger(WordUtil.class);
    private static final String TYPE_DOC = "doc";
    private static final String TYPE_DOCX = "docx";

    private static byte[] replaceInDoc(byte[] fileData, Map<String, String> map) {
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        HWPFDocument document = null;
        try {
            inputStream = new ByteArrayInputStream(fileData);
            document = new HWPFDocument((InputStream)inputStream);
            Range range = document.getRange();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                range.replaceText(entry.getKey(), entry.getValue());
            }
            outputStream = new ByteArrayOutputStream();
            document.write((OutputStream)outputStream);
            Object object = outputStream.toByteArray();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    private static byte[] replaceInDocx(byte[] fileData, Map<String, String> map) {
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        XWPFDocument document = null;
        try {
            inputStream = new ByteArrayInputStream(fileData);
            document = new XWPFDocument((InputStream)inputStream);
            Iterator itPara = document.getParagraphsIterator();
            while (itPara.hasNext()) {
                WordUtil.replaceInAParagraph((XWPFParagraph)itPara.next(), map);
            }
            Iterator itTable = document.getTablesIterator();
            while (itTable.hasNext()) {
                XWPFTable table = (XWPFTable)itTable.next();
                int rCount = table.getNumberOfRows();
                for (int i = 0; i < rCount; ++i) {
                    XWPFTableRow row = table.getRow(i);
                    List cells = row.getTableCells();
                    for (XWPFTableCell cell : cells) {
                        List cellParas = cell.getParagraphs();
                        for (XWPFParagraph cellPara : cellParas) {
                            WordUtil.replaceInAParagraph(cellPara, map);
                        }
                    }
                }
            }
            outputStream = new ByteArrayOutputStream();
            document.write((OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    private static void replaceInAParagraph(XWPFParagraph paragraph, Map<String, String> map) {
        List runs = paragraph.getRuns();
        for (int i = 0; i < runs.size(); ++i) {
            String textPos = ((XWPFRun)runs.get(i)).getText(((XWPFRun)runs.get(i)).getTextPosition());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (textPos == null) continue;
                textPos = textPos.replace(entry.getKey(), entry.getValue());
            }
            ((XWPFRun)runs.get(i)).setText(textPos, 0);
        }
    }

    public static byte[] replace(byte[] fileData, String fileType, Map<String, String> map) {
        if (fileData == null || fileData.length <= 0) {
            throw new IllegalArgumentException("[fileData] can not be empty.");
        }
        Assert.notEmpty(map, (String)"[map] can not be empty.");
        if (TYPE_DOCX.equals(fileType)) {
            return WordUtil.replaceInDocx(fileData, map);
        }
        if (TYPE_DOC.equals(fileType)) {
            return WordUtil.replaceInDoc(fileData, map);
        }
        throw new IllegalArgumentException("[fileType] must be doc or docx.");
    }
}

