/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.assist4j.core.io.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUtil {
    private static final Logger log = LoggerFactory.getLogger(OssUtil.class);
    private String endpoint;
    private String accessKey;
    private String accessSecret;
    private String bucketName;
    private OSSClient ossClient = null;
    private boolean ossClientWithBucketLockInit = false;
    private final ReentrantLock ossClientLock = new ReentrantLock();
    private final ReentrantLock ossClientWithBucketLock = new ReentrantLock();

    public OssUtil(String endpoint, String accessKey, String accessSecret, String bucketName) {
        this.endpoint = endpoint;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.bucketName = bucketName;
    }

    private OSSClient getOSSClient() {
        if (this.ossClient == null) {
            this.ossClientLock.lock();
            try {
                if (this.ossClient == null) {
                    this.ossClient = new OSSClient(this.endpoint, this.accessKey, this.accessSecret);
                }
            }
            finally {
                this.ossClientLock.unlock();
            }
        }
        return this.ossClient;
    }

    private OSSClient getOSSClientWithBucket() {
        OSSClient ossClient = this.getOSSClient();
        if (!this.ossClientWithBucketLockInit) {
            this.ossClientWithBucketLock.lock();
            try {
                if (!this.ossClientWithBucketLockInit) {
                    if (!ossClient.doesBucketExist(this.bucketName)) {
                        ossClient.createBucket(this.bucketName);
                    }
                    ossClient.setBucketAcl(this.bucketName, CannedAccessControlList.PublicRead);
                    this.ossClientWithBucketLockInit = true;
                }
            }
            finally {
                this.ossClientWithBucketLock.unlock();
            }
        }
        return ossClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBucket() {
        if (!this.getOSSClient().doesBucketExist(this.bucketName)) {
            return;
        }
        OssUtil ossUtil = this;
        synchronized (ossUtil) {
            List<String> keyList = this.queryBucketKeyList();
            if (keyList != null && keyList.size() > 0) {
                for (String key : keyList) {
                    this.getOSSClient().deleteObject(this.bucketName, key);
                }
            }
            this.getOSSClient().deleteBucket(this.bucketName);
            this.ossClientWithBucketLockInit = false;
        }
    }

    public List<String> queryBucketKeyList() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.getOSSClient().doesBucketExist(this.bucketName)) {
            return list;
        }
        ObjectListing objectListing = this.getOSSClient().listObjects(this.bucketName);
        List summaryList = objectListing.getObjectSummaries();
        if (summaryList == null || summaryList.size() <= 0) {
            return list;
        }
        for (OSSObjectSummary summary : summaryList) {
            list.add(summary.getKey());
        }
        return list;
    }

    public String uploadFile(byte[] content, String key) {
        log.info("OSS upload file: key[{}]", (Object)key);
        String protocol = "http://";
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength((long)bis.available());
        this.getOSSClientWithBucket().putObject(this.bucketName, key, (InputStream)bis, objectMeta);
        String url = protocol + this.bucketName + "." + this.endpoint.substring(protocol.length()) + "/" + key;
        log.info("URL: {}", (Object)url);
        try {
            bis.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return url;
    }

    public byte[] downloadFile(String key) {
        OSSObject ossObject = this.getOSSClientWithBucket().getObject(new GetObjectRequest(this.bucketName, key));
        if (ossObject == null || ossObject.getObjectContent() == null) {
            return null;
        }
        return StreamUtil.read(ossObject.getObjectContent());
    }

    public URL getDownloadURL(String key) {
        return this.getOSSClientWithBucket().generatePresignedUrl(this.bucketName, key, new Date());
    }

    public void deleteFile(String key) {
        this.getOSSClientWithBucket().deleteObject(this.bucketName, key);
    }
}

