/*
 * Decompiled with CFR 0.152.
 */
package com.assist4j.core.springboot;

import com.assist4j.core.mq.activemq.message.TextSender;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.jms.core.JmsTemplate;

public class ActiveMqConf {
    @Bean(name={"targetConnectionFactory"})
    public ActiveMQConnectionFactory activeMQConnectionFactory(@Value(value="${mq.broker.url}") String brokerUrl, @Value(value="${mq.user.name}") String userName, @Value(value="${mq.password}") String password) {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory();
        activeMQConnectionFactory.setBrokerURL(brokerUrl);
        activeMQConnectionFactory.setUserName(userName);
        activeMQConnectionFactory.setPassword(password);
        return activeMQConnectionFactory;
    }

    @Bean(name={"pooledConnectionFactory"})
    public PooledConnectionFactory pooledConnectionFactory(@Qualifier(value="targetConnectionFactory") Object targetConnectionFactory, @Value(value="${mq.pool.max.connections}") int maxConnections) {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setConnectionFactory(targetConnectionFactory);
        pooledConnectionFactory.setMaxConnections(maxConnections);
        return pooledConnectionFactory;
    }

    @Bean(name={"connectionFactory"})
    public SingleConnectionFactory singleConnectionFactory(@Qualifier(value="pooledConnectionFactory") ConnectionFactory pooledConnectionFactory) {
        SingleConnectionFactory singleConnectionFactory = new SingleConnectionFactory();
        singleConnectionFactory.setTargetConnectionFactory(pooledConnectionFactory);
        return singleConnectionFactory;
    }

    @Bean(name={"activeMqJmsTemplate"})
    public JmsTemplate jmsTemplate(@Qualifier(value="connectionFactory") ConnectionFactory connectionFactory) {
        JmsTemplate jmsTemplate = new JmsTemplate();
        jmsTemplate.setConnectionFactory(connectionFactory);
        return jmsTemplate;
    }

    @Bean(name={"textSender"})
    public TextSender textSender(@Qualifier(value="activeMqJmsTemplate") JmsTemplate jmsTemplate) {
        TextSender textSender = new TextSender();
        textSender.setJmsTemplate(jmsTemplate);
        return textSender;
    }
}

