/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.ASTRAClassLoader;
import astra.core.ASTRAClassNotFoundException;
import astra.core.Agent;
import astra.core.AgentCreationException;
import astra.core.Fragment;
import astra.core.Helper;
import astra.core.Intention;
import astra.core.Rule;
import astra.core.RuleExecutor;
import astra.event.Event;
import astra.formula.Formula;
import astra.formula.Inference;
import astra.formula.Predicate;
import astra.reasoner.Queryable;
import astra.term.Term;
import astra.tr.Function;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public abstract class ASTRAClass
implements Queryable {
    Map<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
    Map<Integer, Function> functions = new HashMap<Integer, Function>();
    Map<Integer, List<Formula>> inferences = new HashMap<Integer, List<Formula>>();
    private Set<String> filter = new HashSet<String>();
    private List<ASTRAClass> linearization;
    private Class<ASTRAClass>[] parents;
    private int distFromRoot = -1;

    public void setParents(Class<ASTRAClass>[] parents) {
        this.parents = parents;
    }

    public synchronized Agent newInstance(String name) throws AgentCreationException, ASTRAClassNotFoundException {
        if (Agent.hasAgent(name)) {
            throw new AgentCreationException("An agent with name: \"" + name + "\" already exists.");
        }
        Agent agent = new Agent(name);
        agent.setMainClass(this);
        return agent;
    }

    public abstract void initialize(Agent var1);

    public abstract Fragment createFragment(Agent var1) throws ASTRAClassNotFoundException;

    public List<ASTRAClass> getLinearization() throws ASTRAClassNotFoundException {
        if (this.linearization == null) {
            ASTRAClass claz;
            this.linearization = new LinkedList<ASTRAClass>();
            PriorityQueue<ASTRAClass> queue = new PriorityQueue<ASTRAClass>(1, (o1, o2) -> o1.getDistance() - o2.getDistance());
            LinkedList<ASTRAClass> queue2 = new LinkedList<ASTRAClass>();
            queue2.add(this);
            while (!queue2.isEmpty()) {
                claz = (ASTRAClass)queue2.poll();
                if (claz.parents == null) continue;
                for (int i = claz.parents.length - 1; i > -1; --i) {
                    ASTRAClass c = ASTRAClassLoader.getDefaultClassLoader().loadClass(claz.parents[i]);
                    if (queue.contains(c) || queue2.contains(c)) continue;
                    queue2.add(c);
                }
                queue.add(claz);
            }
            while (!queue.isEmpty()) {
                claz = (ASTRAClass)queue.poll();
                if (this.linearization.contains(claz)) continue;
                this.linearization.add(0, claz);
            }
        }
        return this.linearization;
    }

    public int getDistance() {
        if (this.distFromRoot == -1) {
            int maxDist = 0;
            if (this.parents != null) {
                for (Class<ASTRAClass> parent : this.parents) {
                    try {
                        ASTRAClass cls = ASTRAClassLoader.getDefaultClassLoader().loadClass(parent);
                        int d = cls.getDistance();
                        if (d <= maxDist) continue;
                        maxDist = d;
                    }
                    catch (ASTRAClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.distFromRoot = maxDist + 1;
        }
        return this.distFromRoot;
    }

    public String toString() {
        return "ASTRAClass:" + this.getClass().getCanonicalName();
    }

    public String getCanonicalName() {
        return this.getClass().getCanonicalName();
    }

    public void addRule(Rule rule) {
        List<Rule> list = this.rules.get(rule.event.signature());
        if (list == null) {
            this.filter.add(rule.event.signature());
            list = new LinkedList<Rule>();
            this.rules.put(rule.event.signature(), list);
        }
        list.add(rule);
    }

    public void addInference(Inference inference) {
        List<Formula> list = this.inferences.get(inference.head().id());
        if (list == null) {
            list = new LinkedList<Formula>();
            this.inferences.put(inference.head().id(), list);
        }
        list.add(inference);
    }

    public void addFunction(Function function) {
        if (this.functions.containsKey(function.identifier.id())) {
            System.out.println("Attempt to add duplicate function :" + function.identifier);
            return;
        }
        this.functions.put(function.identifier.id(), function);
    }

    public Set<String> filter() {
        return this.filter;
    }

    public boolean handleEvent(Event event, Agent agent) {
        List<Rule> list = this.rules.get(event.signature());
        if (list == null) {
            return false;
        }
        for (Rule rule : list) {
            Map<Integer, Term> bindings = Helper.evaluateRule(agent, rule, event);
            if (bindings == null) continue;
            Object source = event.getSource();
            if (source != null) {
                Intention intention = null;
                if (Intention.class.isInstance(source)) {
                    intention = (Intention)source;
                    intention.addSubGoal(event, rule, bindings, null);
                } else if (RuleExecutor.class.isInstance(source)) {
                    RuleExecutor executor = (RuleExecutor)source;
                    intention = executor.intention();
                    intention.addSubGoal(event, rule, bindings, executor);
                }
                intention.resume();
            } else {
                agent.addIntention(new Intention(agent, event, rule, bindings));
            }
            return true;
        }
        return false;
    }

    public static ASTRAClass forName(String url) throws ASTRAClassNotFoundException {
        return ASTRAClassLoader.getDefaultClassLoader().loadClass(url);
    }

    public static ASTRAClass forName(String _package, String url) throws ASTRAClassNotFoundException {
        if (_package == null) {
            return ASTRAClass.forName(url);
        }
        return ASTRAClassLoader.getDefaultClassLoader().loadClass(_package + "." + url);
    }

    public Function getFunction(Predicate predicate) {
        return this.functions.get(predicate.id());
    }

    public boolean hasFunctions() {
        return !this.functions.isEmpty();
    }

    @Override
    public void addMatchingFormulae(Queue<Formula> queue, Formula predicate) {
        List<Formula> list;
        if (predicate instanceof Predicate && (list = this.inferences.get(((Predicate)predicate).id())) != null) {
            queue.addAll(list);
        }
    }

    @Override
    public Iterator<Formula> iterator(Formula formula) {
        if (formula instanceof Predicate) {
            List<Formula> list = this.inferences.get(((Predicate)formula).id());
            return list == null ? Queryable.EMPTY_LIST.iterator() : list.iterator();
        }
        return Queryable.EMPTY_LIST.iterator();
    }

    public boolean isSubclass(ASTRAClass cl) {
        try {
            for (ASTRAClass cls : cl.getLinearization()) {
                if (!cls.getCanonicalName().equals(this.getCanonicalName())) continue;
                return true;
            }
        }
        catch (ASTRAClassNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Map<String, List<Rule>> rules() {
        return this.rules;
    }

    public Class<ASTRAClass>[] getParents() {
        return this.parents;
    }
}

