/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.ASTRAClass;
import astra.core.ASTRAClassNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ASTRAClassLoader {
    private static ASTRAClassLoader defaultClassLoader = new ASTRAClassLoader();
    private List<ClassLoader> loaders = new LinkedList<ClassLoader>();
    private Map<String, ASTRAClass> classes = new HashMap<String, ASTRAClass>();

    public ASTRAClassLoader() {
        this.loaders.add(ClassLoader.getSystemClassLoader());
    }

    public static ASTRAClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public void registerClassLoader(ClassLoader loader) {
        this.loaders.add(loader);
    }

    public ASTRAClass loadClass(String url) throws ASTRAClassNotFoundException {
        ASTRAClass clazz = this.classes.get(url);
        if (clazz == null) {
            ClassLoader loader;
            Class<?> c = null;
            Iterator<ClassLoader> iterator = this.loaders.iterator();
            while (iterator.hasNext() && (c = this.doLoadClass(loader = iterator.next(), url)) == null) {
            }
            if (c != null) {
                try {
                    clazz = (ASTRAClass)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new ASTRAClassNotFoundException("Could not load ASTRA class: " + url, e);
                }
            } else {
                throw new ASTRAClassNotFoundException("Could not find ASTRA class: " + url);
            }
            this.classes.put(url, clazz);
        }
        return clazz;
    }

    public ASTRAClass loadClass(Class<ASTRAClass> cls) throws ASTRAClassNotFoundException {
        ASTRAClass clazz = this.classes.get(cls.getCanonicalName());
        if (clazz == null) {
            try {
                clazz = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ASTRAClassNotFoundException("Could not load ASTRA class: " + cls.getCanonicalName(), e);
            }
            this.classes.put(cls.getCanonicalName(), clazz);
        }
        return clazz;
    }

    private Class<?> doLoadClass(ClassLoader loader, String url) {
        try {
            return loader.loadClass(url);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

