/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.ASTRAClass;
import astra.core.ASTRAClassNotFoundException;
import astra.core.AgentMessageListener;
import astra.core.EventBeliefManager;
import astra.core.Fragment;
import astra.core.Intention;
import astra.core.Module;
import astra.core.RuleExecutor;
import astra.core.Scheduler;
import astra.core.SensorAdaptor;
import astra.core.Task;
import astra.event.Event;
import astra.event.GoalEvent;
import astra.event.ScopedBeliefEvent;
import astra.event.ScopedGoalEvent;
import astra.formula.Formula;
import astra.formula.Goal;
import astra.formula.Predicate;
import astra.formula.ScopedGoal;
import astra.messaging.AstraMessage;
import astra.messaging.MessageEvent;
import astra.reasoner.NewReasoner;
import astra.reasoner.Queryable;
import astra.reasoner.Reasoner;
import astra.term.ListTerm;
import astra.term.Performative;
import astra.term.Primitive;
import astra.term.Term;
import astra.tr.Function;
import astra.tr.TRContext;
import astra.trace.TraceEvent;
import astra.trace.TraceManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Agent
extends Observable
implements Queryable {
    public static final Map<String, Long> timings = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Long> iterations = Collections.synchronizedMap(new HashMap());
    private static Map<String, Agent> agents = new HashMap<String, Agent>();
    public static final int NEW = 0;
    public static final int ACTIVE = 1;
    public static final int STEP = 2;
    public static final int INACTIVE = 3;
    public static final int TERMINATING = 4;
    public static final int TERMINATED = 5;
    private String name;
    private int state = 0;
    private Intention intention;
    private boolean trace = false;
    private Set<String> tokens = new TreeSet<String>();
    private Map<String, LinkedList<Intention>> lockQueueMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Intention> lockMap = Collections.synchronizedMap(new HashMap());
    private Set<String> filter = new TreeSet<String>();
    private BlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>();
    private BlockingQueue<Notification> completed = new LinkedBlockingQueue<Notification>();
    private List<Intention> intentions = Collections.synchronizedList(new ArrayList());
    private Predicate trFunction;
    private ASTRAClass clazz;
    private Map<String, Fragment> linearization = new TreeMap<String, Fragment>();
    private Reasoner reasoner;
    private EventBeliefManager beliefManager;
    private List<Promise> promises = new ArrayList<Promise>();
    private List<SensorAdaptor> sensorArray = new LinkedList<SensorAdaptor>();
    private List<AgentMessageListener> messageListeners = new LinkedList<AgentMessageListener>();
    private long iteration = 0L;
    boolean evts = true;
    Object lock = new Object();

    public static Agent getAgent(String name) {
        return agents.get(name);
    }

    public static boolean hasAgent(String name) {
        return agents.containsKey(name);
    }

    public static Set<String> agentNames() {
        return agents.keySet();
    }

    public Agent(String name) {
        this.name = name;
        timings.put(name, 0L);
        iterations.put(name, 0L);
        this.beliefManager = new EventBeliefManager(this);
        this.reasoner = new NewReasoner(this);
        this.reasoner.addSource(this.beliefManager);
        this.reasoner.addSource(this);
        agents.put(name, this);
    }

    public void addSource(Queryable source) {
        this.reasoner.addSource(source);
    }

    public String name() {
        return this.name;
    }

    public void setMainClass(ASTRAClass clazz) throws ASTRAClassNotFoundException {
        this.clazz = clazz;
        List<ASTRAClass> list = clazz.getLinearization();
        for (ASTRAClass claz : list) {
            this.filter.addAll(claz.filter());
            this.reasoner.addSource(claz);
        }
        Fragment prev = null;
        for (ASTRAClass claz : list) {
            claz.initialize(this);
            Fragment fragment = claz.createFragment(this);
            if (prev != null) {
                prev.next = fragment;
            }
            this.linearization.put(claz.getClass().getCanonicalName(), fragment);
            prev = fragment;
        }
    }

    private List<ASTRAClass> filteredClassList(List<ASTRAClass> classList, String scope) throws ASTRAClassNotFoundException {
        for (ASTRAClass c : classList) {
            if (!c.getCanonicalName().equals(scope) && !c.getClass().getSimpleName().equals(scope)) continue;
            return c.getLinearization();
        }
        return null;
    }

    public boolean handleEvent(Event event) {
        Object source;
        boolean handled;
        block18: {
            block16: {
                block17: {
                    if (this.trace) {
                        System.out.println("__________________________________________________________________________");
                        System.out.println("[" + this.name + "] Handling: " + event);
                        System.out.println("[" + this.name + "] EQ: " + this.eventQueue);
                    }
                    handled = false;
                    source = event.getSource();
                    if (source == null) break block16;
                    if (!Intention.class.isInstance(source)) break block17;
                    handled = ((Intention)source).handleEvent(event, this);
                    break block18;
                }
                if (!RuleExecutor.class.isInstance(source)) break block18;
                handled = ((RuleExecutor)source).intention().handleEvent(event, this);
                break block18;
            }
            for (int i = 0; i < this.intentions.size(); ++i) {
                if (!this.intentions.get(i).handleEvent(event, this)) continue;
                handled = true;
            }
        }
        if (!handled) {
            try {
                List<ASTRAClass> classList = this.clazz.getLinearization();
                if (event instanceof ScopedGoalEvent) {
                    classList = this.filteredClassList(classList, ((ScopedGoalEvent)event).scopedGoal().scope());
                }
                if (event instanceof ScopedBeliefEvent) {
                    classList = this.filteredClassList(classList, ((ScopedBeliefEvent)event).scope());
                    event = ((ScopedBeliefEvent)event).beliefEvent();
                }
                int i = 0;
                while (!handled && i < classList.size()) {
                    ASTRAClass cls;
                    Fragment fragment;
                    if (!(fragment = this.linearization.get((cls = classList.get(i++)).getClass().getCanonicalName())).getASTRAClass().handleEvent(event, this)) continue;
                    handled = true;
                }
            }
            catch (ASTRAClassNotFoundException e) {
                System.err.println("Problem generating linearisation of: " + this.clazz.getClass().getCanonicalName());
                e.printStackTrace();
            }
        }
        if (!handled) {
            if (source != null) {
                Intention lIntention = null;
                if (Intention.class.isInstance(source)) {
                    lIntention = (Intention)source;
                } else if (RuleExecutor.class.isInstance(source)) {
                    lIntention = ((RuleExecutor)source).intention();
                }
                lIntention.failed("Event was not matched to rule: " + event, null);
                lIntention.resume();
            } else if (this.trace) {
                System.out.println("[astra.core.Agent:" + this.name + "] Event: " + event + " was not handled");
            }
        }
        if (this.trace) {
            System.out.println("__________________________________________________________________________");
        }
        return handled;
    }

    public synchronized void execute() {
        int i;
        for (SensorAdaptor adaptor : this.sensorArray) {
            adaptor.sense(this);
        }
        this.beliefManager.update();
        for (i = 0; i < this.promises.size(); ++i) {
            if (!this.promises.get(i).evaluatePromise(this)) continue;
            this.promises.remove(i).act();
        }
        while (!this.completed.isEmpty()) {
            ((Notification)this.completed.poll()).evaluate();
        }
        i = 0;
        while (i < this.intentions.size()) {
            this.intention = this.intentions.get(i);
            if (this.intention.reviseGoals()) {
                this.intentions.remove(i);
                continue;
            }
            ++i;
        }
        while (!this.eventQueue.isEmpty() && !this.handleEvent((Event)this.eventQueue.poll())) {
        }
        if (!this.intentions.isEmpty()) {
            this.intention = this.getNextIntention();
            if (this.intention != null) {
                if (this.intention.isFailed()) {
                    if (!this.intention.rollback()) {
                        this.intentions.remove(this.intention);
                        this.intention.printStackTrace();
                    }
                } else if (!this.intention.execute()) {
                    this.intentions.remove(this.intention);
                }
            }
        }
        if (this.trFunction != null) {
            new TRContext(this, this.trFunction).execute();
        }
        if (this.state != 2) {
            this.setState(this.hasSensors() || this.beliefManager.hasUpdates() || this.hasEvents() || this.hasActiveIntentions() || this.hasActiveFunction() ? 1 : 3);
        }
        TraceManager.getInstance().recordEvent(new TraceEvent("end-of-cycle", Calendar.getInstance().getTime(), this));
        this.setChanged();
        this.notifyObservers();
        ++this.iteration;
    }

    private Intention getNextIntention() {
        if (this.intentions.isEmpty()) {
            return null;
        }
        Intention intent = null;
        boolean selected = false;
        for (int i = 0; i < this.intentions.size() && !selected; ++i) {
            intent = this.intentions.remove(0);
            this.intentions.add(intent);
            selected = !intent.isSuspended();
        }
        return selected ? intent : null;
    }

    public List<Map<Integer, Term>> query(Formula formula, Map<Integer, Term> bindings) {
        return this.reasoner.query(formula, bindings);
    }

    public List<Map<Integer, Term>> queryAll(Formula formula) {
        return this.reasoner.queryAll(formula);
    }

    public void initialize(Goal goal) {
        this.addEvent(new GoalEvent('+', goal));
    }

    public void initialize(ScopedGoal goal) {
        this.addEvent(new ScopedGoalEvent('+', goal));
    }

    public void initialize(Predicate predicate) {
        this.beliefManager.addBelief(predicate);
    }

    public void addIntention(Intention intention) {
        this.intentions.add(0, intention);
    }

    public Module getModule(String classname, String key) {
        Fragment fragment = this.linearization.get(classname == null ? this.clazz.getCanonicalName() : classname);
        for (ASTRAClass claz : fragment.getLinearization()) {
            fragment = this.linearization.get(claz.getClass().getCanonicalName());
            Module module = fragment.getModule(key);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public EventBeliefManager beliefs() {
        return this.beliefManager;
    }

    public void receive(AstraMessage message) {
        for (AgentMessageListener listener : this.messageListeners) {
            listener.receive(message);
        }
        ListTerm list = new ListTerm();
        this.eventQueue.add(new MessageEvent(new Performative(message.performative), Primitive.newPrimitive(message.sender), (Formula)message.content, list));
        this.lazyActivation();
    }

    public boolean addEvent(Event event) {
        if (this.checkEvent(event)) {
            this.lazyActivation();
            return this.eventQueue.add(event);
        }
        return false;
    }

    private boolean checkEvent(Event event) {
        if (this.filter.contains(event.signature())) {
            return true;
        }
        Object source = event.getSource();
        if (source != null) {
            if (Intention.class.isInstance(source)) {
                return ((Intention)source).checkEvent(event);
            }
            if (RuleExecutor.class.isInstance(source)) {
                return ((RuleExecutor)source).intention().checkEvent(event);
            }
        }
        return false;
    }

    public List<Intention> intentions() {
        return this.intentions;
    }

    public void addSensorAdaptor(SensorAdaptor adaptor) {
        this.sensorArray.add(adaptor);
    }

    public void notifyDone(Notification notification) {
        this.completed.add(notification);
    }

    public void schedule(Task task) {
        Scheduler.schedule(task);
    }

    public synchronized boolean hasLock(String token, Intention Intention2) {
        return Intention2.equals(this.lockMap.get(token));
    }

    public synchronized boolean requestLock(String token, Intention Intention2) {
        if (this.tokens.contains(token)) {
            this.lockQueueMap.get(token).addLast(Intention2);
            Intention2.suspend();
            return false;
        }
        this.tokens.add(token);
        this.lockQueueMap.put(token, new LinkedList());
        this.lockMap.put(token, Intention2);
        return true;
    }

    public synchronized void releaseLock(String token, Intention Intention2) {
        if (!this.tokens.contains(token)) {
            System.err.println("[" + this.name() + "] Could not release lock on token: " + token);
        } else {
            LinkedList<Intention> queue;
            if (!this.lockMap.remove(token).equals(Intention2)) {
                System.out.println("[ASTRAAgent.releaseLock()] Something strange: look at lock releasing");
            }
            if ((queue = this.lockQueueMap.get(token)).isEmpty()) {
                this.tokens.remove(token);
            } else {
                Intention ctxt = queue.removeFirst();
                this.lockMap.put(token, ctxt);
                ctxt.resume();
            }
        }
    }

    public void unrequestLock(String token, Intention Intention2) {
        if (!this.tokens.contains(token)) {
            System.err.println("[" + this.name() + "] Could not unrequest lock on token: " + token);
        } else {
            LinkedList<Intention> queue = this.lockQueueMap.get(token);
            queue.remove(Intention2);
            if (queue.isEmpty()) {
                this.tokens.remove(token);
            }
        }
    }

    public synchronized void terminate() {
        this.state = 4;
        agents.remove(this.name);
    }

    public synchronized boolean isTerminating() {
        return this.state == 4;
    }

    public Queue<Event> events() {
        return this.eventQueue;
    }

    public boolean startFunction(Predicate function) {
        if (this.trFunction != null) {
            return false;
        }
        this.trFunction = function;
        return true;
    }

    public boolean stopFunction() {
        if (this.trFunction == null) {
            return false;
        }
        this.trFunction = null;
        return true;
    }

    public Function getFunction(Predicate predicate) {
        Fragment fragment = this.linearization.get(this.clazz.getClass().getCanonicalName());
        while (fragment != null) {
            Function function = fragment.getASTRAClass().getFunction(predicate);
            if (function != null) {
                return function;
            }
            fragment = fragment.next;
        }
        return null;
    }

    public ASTRAClass getASTRAClass() {
        return this.clazz;
    }

    public Intention intention() {
        return this.intention;
    }

    public void addAgentMessageListener(AgentMessageListener listener) {
        this.messageListeners.add(listener);
    }

    public void addPromise(Promise promise) {
        this.promises.add(promise);
    }

    public void dropPromise(Promise promise) {
        this.promises.remove(promise);
    }

    public boolean hasActiveFunction() {
        return this.trFunction != null;
    }

    public boolean hasSensors() {
        return !this.sensorArray.isEmpty();
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public void addMatchingFormulae(Queue<Formula> queue, Formula formula) {
        if (formula instanceof Goal) {
            for (Intention lIntention : this.intentions) {
                lIntention.addGoals(queue, (Goal)formula);
            }
        }
    }

    @Override
    public Iterator<Formula> iterator(Formula formula) {
        if (formula instanceof Goal) {
            LinkedList<Formula> queue = new LinkedList<Formula>();
            for (Intention lIntention : this.intentions) {
                lIntention.addGoals(queue, (Goal)formula);
            }
            return queue.iterator();
        }
        return Queryable.EMPTY_LIST.iterator();
    }

    public boolean trace() {
        return this.trace;
    }

    public boolean hasEvents() {
        this.evts = !this.evts || this.eventQueue.isEmpty();
        return !this.eventQueue.isEmpty();
    }

    public String toString() {
        return this.name;
    }

    public boolean hasActiveIntentions() {
        return !this.intentions.isEmpty();
    }

    public boolean isInactive() {
        return this.state == 3;
    }

    public boolean isActive() {
        return this.state == 1;
    }

    public boolean isStep() {
        return this.state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int state) {
        Object object = this.lock;
        synchronized (object) {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyActivation() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 3) {
                this.state = 1;
                Scheduler.schedule(this);
            }
        }
    }

    public long getIteration() {
        return this.iteration;
    }

    public static abstract class Promise {
        public boolean isTrue;

        public Promise() {
            this(false);
        }

        public Promise(boolean isTrue) {
            this.isTrue = isTrue;
        }

        public boolean evaluatePromise(Agent agent) {
            boolean evaluated = this.evaluate(agent);
            return this.isTrue && !evaluated || !this.isTrue && evaluated;
        }

        public abstract boolean evaluate(Agent var1);

        public abstract void act();
    }

    public static class Notification {
        Intention intention;
        String message;
        Throwable th;

        public Notification(Intention intention, String message) {
            this.intention = intention;
            this.message = message;
        }

        public Notification(Intention Intention2, String message, Throwable th) {
            this.intention = Intention2;
            this.message = message;
            this.th = th;
        }

        public void evaluate() {
            if (this.message != null) {
                this.intention.failed(this.message, this.th);
            }
            this.intention.resume();
        }
    }
}

