/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.formula.Formula;
import astra.formula.Predicate;
import astra.reasoner.Queryable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class BeliefStore {
    private Map<Integer, List<Formula>> store = new HashMap<Integer, List<Formula>>();
    int size = 0;

    public boolean addBelief(Predicate belief) {
        List<Formula> list = this.store.get(belief.id());
        if (list == null) {
            list = new LinkedList<Formula>();
            this.store.put(belief.id(), list);
        }
        for (Formula element : list) {
            if (!element.equals(belief)) continue;
            return false;
        }
        list.add(belief);
        ++this.size;
        return true;
    }

    public boolean containsBelief(Predicate belief) {
        List<Formula> list = this.store.get(belief.id());
        if (list == null) {
            return false;
        }
        for (Formula element : list) {
            if (!element.equals(belief)) continue;
            return true;
        }
        return false;
    }

    public boolean removeBelief(Predicate belief) {
        List<Formula> list = this.store.get(belief.id());
        if (list == null) {
            return false;
        }
        for (Formula element : list) {
            if (!element.equals(belief)) continue;
            list.remove(element);
            --this.size;
            return true;
        }
        return false;
    }

    public List<Formula> beliefs() {
        LinkedList<Formula> list = new LinkedList<Formula>();
        for (List<Formula> l : this.store.values()) {
            list.addAll(l);
        }
        return list;
    }

    public void clear() {
        this.store.clear();
    }

    public void addMatchingBeliefs(Queue<Formula> queue, Predicate formula) {
        List<Formula> list = this.store.get(formula.id());
        if (list != null) {
            queue.addAll(list);
        }
    }

    public Iterator<Formula> iterator(Formula formula) {
        if (formula instanceof Predicate) {
            List<Formula> list = this.store.get(((Predicate)formula).id());
            return list == null ? Queryable.EMPTY_LIST.iterator() : list.iterator();
        }
        return Queryable.EMPTY_LIST.iterator();
    }

    public int size() {
        return this.size;
    }
}

