/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.Agent;
import astra.core.BeliefStore;
import astra.event.BeliefEvent;
import astra.event.ScopedBeliefEvent;
import astra.formula.Formula;
import astra.formula.Predicate;
import astra.reasoner.Queryable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class EventBeliefManager
implements Queryable {
    BeliefStore store = new BeliefStore();
    Agent agent;
    List<Predicate> addedBeliefs = Collections.synchronizedList(new LinkedList());
    List<Predicate> droppedBeliefs = Collections.synchronizedList(new LinkedList());
    private Map<Predicate, String> scopes = new HashMap<Predicate, String>();

    public EventBeliefManager(Agent agent) {
        this.agent = agent;
    }

    public void addBelief(Predicate belief) {
        this.addedBeliefs.add(belief);
    }

    public void dropBelief(Predicate belief) {
        this.droppedBeliefs.add(belief);
    }

    public void update() {
        String scope;
        Predicate belief;
        while (!this.addedBeliefs.isEmpty()) {
            belief = this.addedBeliefs.remove(0);
            if (!this.store.addBelief(belief)) continue;
            scope = this.scopes.remove(belief);
            if (scope != null) {
                this.agent.addEvent(new ScopedBeliefEvent(scope, new BeliefEvent('+', belief)));
                continue;
            }
            this.agent.addEvent(new BeliefEvent('+', belief));
        }
        while (!this.droppedBeliefs.isEmpty()) {
            belief = this.droppedBeliefs.remove(0);
            if (!this.store.removeBelief(belief)) continue;
            scope = this.scopes.remove(belief);
            if (scope != null) {
                this.agent.addEvent(new ScopedBeliefEvent(scope, new BeliefEvent('-', belief)));
                continue;
            }
            this.agent.addEvent(new BeliefEvent('-', belief));
        }
    }

    public int size() {
        return this.store.size();
    }

    public List<Formula> beliefs() {
        return this.store.beliefs();
    }

    public void dumpBeliefs() {
        for (Formula belief : this.store.beliefs()) {
            System.err.println(belief);
        }
    }

    public boolean hasUpdates() {
        return !this.addedBeliefs.isEmpty() || !this.droppedBeliefs.isEmpty();
    }

    public void addScopedBelief(String scope, Predicate belief) {
        this.scopes.put(belief, scope);
        this.addBelief(belief);
    }

    public void dropScopedBelief(String scope, Predicate belief) {
        this.scopes.put(belief, scope);
        this.dropBelief(belief);
    }

    public BeliefStore store() {
        return this.store;
    }

    @Override
    public void addMatchingFormulae(Queue<Formula> queue, Formula formula) {
        if (formula instanceof Predicate) {
            this.store.addMatchingBeliefs(queue, (Predicate)formula);
        }
    }

    @Override
    public Iterator<Formula> iterator(Formula target) {
        return this.store.iterator(target);
    }
}

