/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.Rule;
import astra.event.Event;
import astra.formula.Formula;
import astra.formula.IsDone;
import astra.formula.Predicate;
import astra.reasoner.util.LogicVisitor;
import astra.statement.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GoalRule
extends Rule {
    public Formula dropCondition;
    public Map<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
    public Set<String> filter = new HashSet<String>();

    public GoalRule(Event event, Statement statement) {
        this(event, Predicate.TRUE, new IsDone(), statement);
    }

    public GoalRule(Event event, Formula context, Statement statement) {
        this(event, context, new IsDone(), statement);
    }

    public GoalRule(Event event, Formula context, Formula dropCondition, Statement statement) {
        super(event, context, statement);
        this.dropCondition = dropCondition;
    }

    public GoalRule(String clazz, int[] data, Event event, Statement statement) {
        this(clazz, data, event, (Formula)Predicate.TRUE, new IsDone(), statement);
    }

    public GoalRule(String clazz, int[] data, Event event, Formula context, Statement statement) {
        this(clazz, data, event, context, new IsDone(), statement);
    }

    public GoalRule(String clazz, int[] data, Event event, Formula context, Statement statement, Rule[] rules) {
        this(clazz, data, event, context, new IsDone(), statement);
        for (int i = 0; i < rules.length; ++i) {
            this.addRule(rules[i]);
        }
    }

    public GoalRule(String clazz, int[] data, Event event, Formula context, Formula dropCondition, Statement statement) {
        super(clazz, data, event, context, statement);
        this.dropCondition = dropCondition;
    }

    public GoalRule(String clazz, int[] data, Event event, Formula context, Formula dropCondition, Statement statement, Rule[] rules) {
        this(clazz, data, event, context, dropCondition, statement);
        for (int i = 0; i < rules.length; ++i) {
            this.addRule(rules[i]);
        }
    }

    public Map<String, List<Rule>> rules() {
        return this.rules;
    }

    public void addRule(Rule rule) {
        List<Rule> list = this.rules.get(rule.event.signature());
        if (list == null) {
            this.filter.add(rule.event.signature());
            list = new LinkedList<Rule>();
            this.rules.put(rule.event.signature(), list);
        }
        list.add(rule);
    }

    public Set<String> filter() {
        return this.filter;
    }

    @Override
    public String toString() {
        return this.event.toString() + " : " + this.context.toString();
    }

    @Override
    public Rule accept(LogicVisitor visitor) {
        GoalRule goalRule = new GoalRule(this.event.accept(visitor), (Formula)this.context.accept(visitor), (Formula)this.dropCondition.accept(visitor), this.statement);
        for (List<Rule> list : this.rules.values()) {
            for (Rule rule : list) {
                goalRule.addRule(rule.accept(visitor));
            }
        }
        return goalRule;
    }
}

