/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.formula.Formula;
import astra.formula.Predicate;
import astra.type.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HierarchicalBeliefStore {
    private StoreNode root = new StoreNode(0);
    private int size = 0;

    public boolean addBelief(Predicate belief) {
        boolean result = this.root.add(belief);
        if (result) {
            ++this.size;
        }
        return result;
    }

    public boolean removeBelief(Predicate belief) {
        boolean result = this.root.remove(belief);
        if (result) {
            --this.size;
        }
        return result;
    }

    public List<Formula> beliefs() {
        LinkedList<Formula> list = new LinkedList<Formula>();
        this.root.getBeliefs(list);
        return list;
    }

    public List<Formula> getMatchingBeliefs(Predicate formula) {
        return this.root.match(formula);
    }

    public int size() {
        return this.size;
    }

    class StoreNode {
        int index;
        List<Formula> predicates = new LinkedList<Formula>();
        Map<Type, StoreNode> layers = new HashMap<Type, StoreNode>();

        public StoreNode(int index) {
            this.index = index;
        }

        public boolean add(Predicate predicate) {
            if (predicate.size() == this.index) {
                if (!this.predicates.contains(predicate)) {
                    this.predicates.add(predicate);
                    return true;
                }
                return false;
            }
            StoreNode layer = this.layers.get(predicate.getTerm(this.index).type());
            if (layer == null) {
                layer = new StoreNode(this.index + 1);
                this.layers.put(predicate.getTerm(this.index).type(), layer);
            }
            return layer.add(predicate);
        }

        public boolean remove(Predicate predicate) {
            if (predicate.size() == this.index) {
                return this.predicates.remove(predicate);
            }
            StoreNode layer = this.layers.get(predicate.getTerm(this.index).type());
            if (layer == null) {
                return false;
            }
            return layer.remove(predicate);
        }

        public List<Formula> match(Predicate predicate) {
            if (predicate.size() == this.index) {
                return this.predicates;
            }
            StoreNode layer = this.layers.get(predicate.getTerm(this.index).type());
            if (layer == null) {
                return new LinkedList<Formula>();
            }
            return layer.match(predicate);
        }

        public void getBeliefs(List<Formula> list) {
            list.addAll(this.predicates);
            for (StoreNode node : this.layers.values()) {
                node.getBeliefs(list);
            }
        }
    }
}

