/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.ActionParam;
import astra.core.Agent;
import astra.core.GoalRule;
import astra.core.Helper;
import astra.core.Module;
import astra.core.Rule;
import astra.core.RuleExecutor;
import astra.core.Task;
import astra.event.Event;
import astra.event.GoalEvent;
import astra.event.ScopedGoalEvent;
import astra.formula.Formula;
import astra.formula.Goal;
import astra.formula.Predicate;
import astra.formula.ScopedGoal;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.StatementHandler;
import astra.statement.Subgoal;
import astra.term.AtIndex;
import astra.term.FormulaTerm;
import astra.term.Funct;
import astra.term.Head;
import astra.term.ListTerm;
import astra.term.ModuleTerm;
import astra.term.NullTerm;
import astra.term.Operator;
import astra.term.Primitive;
import astra.term.Tail;
import astra.term.Term;
import astra.term.Variable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;

public class Intention {
    public int age = 0;
    Map<Variable, ActionParam<?>> actionParams = new HashMap();
    Stack<StatementHandler> failureTrace;
    String failureReason;
    private Throwable exception;
    public Agent agent;
    public Event event;
    private Rule rule;
    Map<Integer, Term> bindings;
    boolean suspended = false;
    boolean failed = false;
    boolean recovering = false;
    boolean hasGoalRule = false;
    Stack<RuleExecutor> executors = new Stack();

    public Intention(Agent agent, Event event, Rule rule, Map<Integer, Term> bindings) {
        this.agent = agent;
        this.event = event;
        this.bindings = bindings;
        this.rule = rule;
        this.hasGoalRule = rule instanceof GoalRule;
        this.executors.push(new RuleExecutor(event, rule, bindings, null, this));
    }

    public synchronized boolean execute() {
        if (!this.executors.isEmpty()) {
            RuleExecutor executor = this.executors.peek();
            try {
                boolean result = executor.execute(this);
                if (!(this.isSuspended() || result || GoalRule.class.isInstance(executor.rule()))) {
                    this.executors.pop();
                    if (executor.parent() != null) {
                        executor.parent().updateRuleBindings(executor.getUnboundBindings());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.failed("Error executing statement: " + executor.getNextStatment().toString(), e);
                executor.printStackTrace();
            }
        }
        return !this.executors.isEmpty();
    }

    public Module getModule(String classname, String key) {
        return this.agent.getModule(classname, key);
    }

    public <T> T evaluate(Term term) {
        if (term instanceof Primitive) {
            return ((Primitive)term).value();
        }
        if (term instanceof Variable) {
            Term val = this.getValue((Variable)term);
            if (val instanceof NullTerm) {
                return null;
            }
            if (val == null) {
                ActionParam param = new ActionParam();
                this.actionParams.put((Variable)term, param);
                return (T)param;
            }
            return this.evaluate(val);
        }
        if (term instanceof Operator || term instanceof ModuleTerm) {
            Term t = (Term)term.accept(new ContextEvaluateVisitor(this));
            if (t instanceof Primitive) {
                return ((Primitive)t).value();
            }
            return (T)t;
        }
        if (term instanceof FormulaTerm) {
            return (T)((FormulaTerm)term).value();
        }
        if (term instanceof ListTerm) {
            return (T)term.accept(new ContextEvaluateVisitor(this, false));
        }
        if (term instanceof Funct) {
            return (T)term.accept(new ContextEvaluateVisitor(this));
        }
        if (term instanceof Head || term instanceof Tail || term instanceof AtIndex) {
            Term _term = (Term)term.accept(new ContextEvaluateVisitor(this));
            return this.evaluate(_term);
        }
        System.out.println("term: " + term);
        System.out.println("EVALUATE: " + term.getClass().getName());
        return null;
    }

    public Term getValue(Variable term) {
        Term value = null;
        int i = this.executors.size() - 1;
        value = ((RuleExecutor)this.executors.get(i--)).getValue(term);
        while (value == null && i >= 0) {
            RuleExecutor executor;
            if (!GoalRule.class.isInstance((executor = (RuleExecutor)this.executors.get(i--)).rule())) continue;
            value = executor.getValue(term);
        }
        return value;
    }

    public void addSubGoal(Event event, Rule rule, Map<Integer, Term> bindings, RuleExecutor parent) {
        if (rule instanceof GoalRule) {
            this.hasGoalRule = true;
        }
        this.executors.push(new RuleExecutor(event, rule, bindings, parent, this));
    }

    public boolean updateVariable(Variable term, Term logic) {
        boolean updated = false;
        int i = this.executors.size() - 1;
        while (!updated && i >= 0) {
            updated = ((RuleExecutor)this.executors.get(i--)).updateVariable(term, logic);
        }
        return updated;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int i = this.executors.size() - 1; i >= 0; --i) {
            out.append(((RuleExecutor)this.executors.get(i)).event()).append("\n");
        }
        return out.toString();
    }

    public void failed(String reason) {
        this.failed(reason, null);
    }

    public void failed(String reason, Throwable exception) {
        this.failed = true;
        this.failureTrace = new Stack();
        for (RuleExecutor executor : this.executors) {
            executor.buildFailureTrace(this.failureTrace);
        }
        this.failureReason = reason;
        this.exception = exception;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void printStackTrace() {
        if (this.failureTrace == null) {
            return;
        }
        System.out.println("[" + this.agent.name() + "] " + this.failureReason);
        for (int i = this.failureTrace.size() - 1; i >= 0; --i) {
            if (!(((StatementHandler)this.failureTrace.get(i)).statement() instanceof Subgoal) && i != this.failureTrace.size() - 1) continue;
            System.out.print("[" + this.agent.name() + "] " + ((StatementHandler)this.failureTrace.get(i)).statement().getASTRAClass() + "." + this.failureTrace.get(i));
            if (((StatementHandler)this.failureTrace.get(i)).statement().isLinkedToSource()) {
                System.out.print(":" + ((StatementHandler)this.failureTrace.get(i)).statement().beginLine());
            }
            System.out.println();
        }
        System.out.println("[" + this.agent.name() + "] " + this.event.toString());
        if (this.exception != null) {
            System.err.println("[" + this.agent.name() + "] Caused By:");
            this.exception.printStackTrace();
        }
    }

    public boolean rollback() {
        while (!this.executors.isEmpty()) {
            RuleExecutor executor = this.executors.peek();
            if (executor.rollback(this)) {
                this.failed = false;
                this.resume();
                return true;
            }
            this.executors.pop();
            if (!this.failed || !(executor.event() instanceof GoalEvent)) continue;
            GoalEvent goalEvent = (GoalEvent)executor.event();
            GoalEvent removalEvent = new GoalEvent('-', goalEvent.goal(), this);
            if (goalEvent.type != '+' || !this.agent.addEvent(removalEvent)) continue;
            this.recovering = true;
            this.failed = false;
            return true;
        }
        return false;
    }

    public void addBelief(Predicate belief) {
        this.agent.beliefs().addBelief(belief);
    }

    public void removeBelief(Predicate belief) {
        this.agent.beliefs().dropBelief(belief);
    }

    public void suspend() {
        this.suspended = true;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isRecovering() {
        return this.recovering;
    }

    public void resume() {
        if (this.recovering) {
            this.recovering = false;
        }
        this.suspended = false;
    }

    public void resetActionParams() {
        this.actionParams.clear();
    }

    public void applyActionParams() {
        for (Map.Entry<Variable, ActionParam<?>> entry : this.actionParams.entrySet()) {
            this.updateVariable(entry.getKey(), entry.getValue().toLogic());
        }
    }

    public void dumpStack() {
        System.out.println("Intention State: " + (this.isActive() ? "ACTIVE" : "SUSPENDED"));
        for (int i = this.executors.size() - 1; i >= 0; --i) {
            System.out.println(i + ". " + ((RuleExecutor)this.executors.get(i)).event() + ": " + ((RuleExecutor)this.executors.get(i)).bindings());
        }
        System.out.println("\n\n" + this.generateIntentionTree());
    }

    public String generateIntentionTree() {
        HashSet<String> baseRules = new HashSet<String>();
        HashMap<String, List<String>> children = new HashMap<String, List<String>>();
        for (RuleExecutor executor : this.executors) {
            if (executor.parent() == null) {
                baseRules.add(executor.event().toString() + ": " + executor.bindings());
                continue;
            }
            String parent = executor.parent().event().toString() + ": " + executor.parent().bindings();
            List list = children.computeIfAbsent(parent, s -> new LinkedList());
            list.add(executor.event().toString() + ": " + executor.bindings());
        }
        StringBuffer buf = new StringBuffer();
        for (String node : baseRules) {
            buf.append(node).append("\n");
            this.addChildren(buf, node, children, "\t");
        }
        return buf.toString();
    }

    private void addChildren(StringBuffer buf, String node, Map<String, List<String>> children, String tabs) {
        List<String> list = children.get(node);
        if (list == null) {
            return;
        }
        for (String item : list) {
            buf.append(tabs).append(item).append("\n");
            this.addChildren(buf, item, children, tabs + "\t");
        }
    }

    public boolean addGoal(Goal goal) {
        return this.agent.addEvent(new GoalEvent('+', goal));
    }

    public boolean addScopedGoal(String scope, Goal goal) {
        return this.agent.addEvent(new ScopedGoalEvent('+', new ScopedGoal(scope, goal)));
    }

    public void notifyDone(String message) {
        this.agent.notifyDone(new Agent.Notification(this, message));
    }

    public void notifyDone(String message, Throwable exception) {
        this.agent.notifyDone(new Agent.Notification(this, message, exception));
    }

    public void schedule(Task task) {
        this.agent.schedule(task);
    }

    public String name() {
        return this.agent.name();
    }

    public Map<Integer, Term> query(Formula formula) {
        List<Map<Integer, Term>> result = this.agent.query(formula, new HashMap<Integer, Term>());
        if (result == null) {
            return null;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public List<Map<Integer, Term>> queryAll(Formula formula) {
        return this.agent.queryAll(formula);
    }

    public boolean startFunction(Predicate function) {
        return this.agent.startFunction(function);
    }

    public boolean stopFunction() {
        return this.agent.stopFunction();
    }

    public StatementHandler getNextStatement() {
        return this.executors.peek().getNextStatment();
    }

    public void addEvent(Event event) {
        this.agent.addEvent(event);
    }

    public boolean hasLock(String token, Intention context) {
        return this.agent.hasLock(token, context);
    }

    public boolean requestLock(String token, Intention context) {
        return this.agent.requestLock(token, context);
    }

    public void releaseLock(String token, Intention context) {
        this.agent.releaseLock(token, context);
    }

    public void unrequestLock(String token, Intention context) {
        this.agent.unrequestLock(token, context);
    }

    public void addScopedBelief(String scope, Predicate belief) {
        this.agent.beliefs().addScopedBelief(scope, belief);
    }

    public void removeScopedBelief(String scope, Predicate belief) {
        this.agent.beliefs().dropScopedBelief(scope, belief);
    }

    public String failureReason() {
        return this.failureReason;
    }

    public void makePromise(Agent.Promise promise) {
        this.agent.addPromise(promise);
    }

    public void dropPromise(Agent.Promise promise) {
        this.agent.dropPromise(promise);
    }

    public boolean handleEvent(Event event, Agent agent) {
        boolean success = false;
        for (int i = this.executors.size() - 1; !success && i >= 0; --i) {
            RuleExecutor executor = (RuleExecutor)this.executors.get(i);
            if (!GoalRule.class.isInstance(executor.rule())) continue;
            if (agent.trace()) {
                System.out.println("[" + agent.name() + "] \tChecking Rule: " + executor.event());
            }
            success = this.evaluateRules(event, executor);
        }
        return success;
    }

    private boolean evaluateRules(Event event, RuleExecutor executor) {
        GoalRule goalRule = (GoalRule)executor.rule();
        List<Rule> list = goalRule.rules().get(event.signature());
        if (list == null) {
            return false;
        }
        for (Rule lRule : list) {
            Map<Integer, Term> lBindings;
            Rule revisedRule = lRule.accept(new BindingsEvaluateVisitor(executor.getAllBindings(), this.agent));
            if (this.agent.trace()) {
                System.out.println("[" + this.agent.name() + "] Revised Rule: " + revisedRule.event + " / bindings: " + executor.getAllBindings());
            }
            if ((lBindings = Helper.evaluateRule(this.agent, revisedRule, event)) == null) continue;
            if (RuleExecutor.class.isInstance(event.getSource())) {
                if (this.agent.trace()) {
                    System.out.println("[" + this.agent.name() + "]\tADDED AS RULE SUBGOAL");
                }
                this.addSubGoal(event, lRule, lBindings, (RuleExecutor)event.getSource());
            } else {
                if (this.agent.trace()) {
                    System.out.println("[" + this.agent.name() + "]\tADDED AS SUBGOAL");
                }
                this.addSubGoal(event, lRule, lBindings, executor);
            }
            this.resume();
            return true;
        }
        return false;
    }

    public Rule rule() {
        if (this.executors.isEmpty()) {
            return this.rule;
        }
        return this.executors.peek().rule();
    }

    public boolean isGoalCompleted() {
        if (this.executors.isEmpty()) {
            return true;
        }
        return this.executors.peek().isDone();
    }

    public synchronized void done() {
        if (this.agent.trace()) {
            System.out.println("---------------------------------------------------------------------------");
        }
        if (this.agent.trace()) {
            System.out.println("done() called for intention: " + this.event);
        }
        boolean updated = false;
        while (!updated) {
            RuleExecutor executor = this.executors.pop();
            if (this.agent.trace()) {
                System.out.println("\tRemoved: " + executor.event());
            }
            if (this.executors.isEmpty()) {
                updated = true;
                continue;
            }
            this.executors.peek().updateRuleBindings(executor.getUnboundBindings());
            updated = GoalRule.class.isInstance(executor.rule());
        }
    }

    public boolean isActive() {
        return !this.suspended && !this.failed;
    }

    public synchronized boolean checkEvent(Event event) {
        if (!this.hasGoalRule) {
            return false;
        }
        String signature = event.signature();
        for (int i = this.executors.size() - 1; i >= 0; --i) {
            Rule lRule = ((RuleExecutor)this.executors.get(i)).rule();
            if (!GoalRule.class.isInstance(lRule) || !((GoalRule)lRule).filter().contains(signature)) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, Term> bindings() {
        return this.executors.peek().bindings();
    }

    public void addGoals(Queue<Formula> queue, Goal goal) {
        if (this.event instanceof GoalEvent) {
            Goal gl = ((GoalEvent)this.event).goal();
            if (gl.formula().id() == goal.formula().id()) {
                queue.add(gl);
            }
            for (RuleExecutor executor : this.executors) {
                executor.addGoals(queue, goal);
            }
        }
    }

    public boolean reviseGoals() {
        if (!this.hasGoalRule) {
            return this.executors.isEmpty();
        }
        for (int i = this.executors.size() - 1; i >= 0; --i) {
            RuleExecutor executor = (RuleExecutor)this.executors.get(i);
            if (!GoalRule.class.isInstance(executor.rule()) || !this.evaluationDropCondition((GoalRule)executor.rule())) continue;
            while (this.executors.size() > i) {
                RuleExecutor ex = this.executors.pop();
                if (ex.parent() != null) {
                    ex.parent().updateRuleBindings(ex.getUnboundBindings());
                    continue;
                }
                if (this.executors.isEmpty()) continue;
                this.executors.peek().updateRuleBindings(ex.getUnboundBindings());
            }
        }
        return this.executors.isEmpty();
    }

    private boolean evaluationDropCondition(GoalRule rule) {
        return this.agent.query((Formula)rule.dropCondition.accept(new ContextEvaluateVisitor(this)), new HashMap<Integer, Term>()) != null;
    }

    public RuleExecutor executor() {
        return this.executors.peek();
    }

    public boolean trace() {
        return this.agent.trace();
    }

    public boolean isDone() {
        return this.executors.size() == 1 && ((RuleExecutor)this.executors.get(0)).isDone();
    }

    public boolean isProcessing() {
        return true;
    }
}

