/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.Intention;
import astra.core.Rule;
import astra.core.StatementExecutor;
import astra.event.Event;
import astra.formula.Formula;
import astra.formula.Goal;
import astra.statement.Block;
import astra.statement.StatementHandler;
import astra.term.Term;
import astra.term.Variable;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;

public class RuleExecutor {
    private Event event;
    private Rule rule;
    private Map<Integer, Term> bindings;
    private Stack<StatementExecutor> executors = new Stack();
    private Map<Integer, Term> unbound;
    private RuleExecutor parent;
    private Intention intention;

    public RuleExecutor(Event event, Rule rule, Map<Integer, Term> bindings, RuleExecutor parent, Intention intention) {
        this.event = event;
        this.rule = rule;
        this.bindings = bindings;
        this.parent = parent;
        this.intention = intention;
        if (intention == null) {
            System.out.println("Intention is null: " + event);
        }
        StatementHandler handler = rule.statement.getStatementHandler();
        handler.setRuleExecutor(this);
        this.executors.add(new StatementExecutor(handler));
        this.captureUnboundVariables();
    }

    private void captureUnboundVariables() {
        this.unbound = new HashMap<Integer, Term>();
        for (Map.Entry<Integer, Term> entry : this.bindings.entrySet()) {
            if (!(entry.getValue() instanceof Variable)) continue;
            Variable var = (Variable)entry.getValue();
            this.unbound.put(var.id(), new Variable(var.type(), entry.getKey()));
        }
    }

    public void addUnboundVariables(Set<Variable> variables) {
        for (Variable variable : variables) {
            if (this.getValue(variable) != null) continue;
            this.addVariable(variable);
        }
    }

    public Map<Integer, Term> getUnboundBindings() {
        for (Map.Entry<Integer, Term> entry : this.unbound.entrySet()) {
            if (!Variable.class.isInstance(entry.getValue())) continue;
            this.unbound.put(entry.getKey(), this.bindings.get(((Variable)entry.getValue()).id()));
        }
        return this.unbound;
    }

    public void updateRuleBindings(Map<Integer, Term> bindings) {
        int i = this.executors.size() - 1;
        while (i >= 0) {
            StatementExecutor executor;
            if ((executor = (StatementExecutor)this.executors.get(i--)).bindings() == null) continue;
            this.updateBindings(executor.bindings(), bindings);
        }
        this.updateBindings(this.bindings, bindings);
    }

    private void updateBindings(Map<Integer, Term> bindings, Map<Integer, Term> bindings2) {
        for (Map.Entry<Integer, Term> entry : bindings.entrySet()) {
            if (entry.getValue() != null) continue;
            bindings.put(entry.getKey(), bindings2.get(entry.getKey()));
        }
    }

    public boolean execute(Intention intention) {
        if (this.executors.isEmpty()) {
            return false;
        }
        int currentSize = 0;
        while (currentSize != this.executors.size()) {
            currentSize = this.executors.size();
            this.executors.peek().execute(intention);
        }
        while (!this.executors.isEmpty() && this.executors.peek().isFinished()) {
            this.executors.pop();
        }
        return !this.executors.isEmpty();
    }

    public boolean isDone() {
        return this.executors.isEmpty();
    }

    public void addStatement(StatementHandler handler) {
        handler.setRuleExecutor(this);
        StatementExecutor executor = null;
        executor = handler.statement() instanceof Block ? new StatementExecutor(handler, new HashMap<Integer, Term>()) : new StatementExecutor(handler);
        this.executors.push(executor);
    }

    public void addStatement(StatementHandler handler, Map<Integer, Term> bindings) {
        handler.setRuleExecutor(this);
        this.executors.push(new StatementExecutor(handler, bindings));
    }

    public Event event() {
        return this.event;
    }

    public void addVariable(Variable variable) {
        this.addVariable(variable, null);
    }

    public void addVariable(Variable variable, Term term) {
        Map<Integer, Term> b = this.getTopBindings();
        if (b == null) {
            b = this.bindings;
        }
        b.put(variable.id(), term);
    }

    public void removeVariable(Variable variable) {
        Map<Integer, Term> b = this.getTopBindings();
        if (b == null) {
            b = this.bindings;
        }
        b.remove(variable.id());
    }

    private Map<Integer, Term> getTopBindings() {
        for (int i = this.executors.size() - 1; i >= 0; --i) {
            if (((StatementExecutor)this.executors.get(i)).bindings() == null) continue;
            return ((StatementExecutor)this.executors.get(i)).bindings();
        }
        return null;
    }

    public boolean updateVariable(Variable term, Term logic) {
        for (int i = this.executors.size() - 1; i >= 0; --i) {
            if (((StatementExecutor)this.executors.get(i)).bindings() == null || !((StatementExecutor)this.executors.get(i)).updateVariable(term, logic)) continue;
            return true;
        }
        if (this.bindings.containsKey(term.id())) {
            this.bindings.put(term.id(), logic);
            return true;
        }
        return false;
    }

    public Term getValue(Variable term) {
        int i = this.executors.size() - 1;
        while (i >= 0) {
            StatementExecutor executor;
            if ((executor = (StatementExecutor)this.executors.get(i--)).bindings() == null || !executor.bindings().containsKey(term.id())) continue;
            return executor.bindings().get(term.id());
        }
        return this.bindings.get(term.id());
    }

    public Map<Integer, Term> bindings() {
        return this.bindings;
    }

    public String toString() {
        return this.rule.toString();
    }

    public String variableTrace() {
        StringBuilder out = new StringBuilder();
        int i = this.executors.size() - 1;
        while (i >= 0) {
            StatementExecutor executor;
            if ((executor = (StatementExecutor)this.executors.get(i--)).bindings() == null) continue;
            out.append("(").append(i + 1).append("). ").append(executor.bindings()).append("\n");
        }
        out.append("(BASE). ").append(this.bindings).append("\n");
        return out.toString();
    }

    public StatementHandler getNextStatment() {
        return this.executors.peek().getStatement();
    }

    public boolean rollback(Intention intention) {
        while (!this.executors.isEmpty()) {
            StatementExecutor executor = this.executors.peek();
            if (executor.rollback(intention)) {
                return true;
            }
            this.executors.pop();
        }
        return false;
    }

    public void buildFailureTrace(Stack<StatementHandler> failureTrace) {
        for (StatementExecutor executor : this.executors) {
            executor.buildFailureTrace(failureTrace);
        }
    }

    public void addBindings(Map<Integer, Term> bindings) {
        Map<Integer, Term> b = this.getTopBindings();
        if (b == null) {
            b = this.bindings;
        }
        for (Map.Entry<Integer, Term> entry : bindings.entrySet()) {
            if (b.containsKey(entry.getKey())) continue;
            b.put(entry.getKey(), entry.getValue());
        }
    }

    public Rule rule() {
        return this.rule;
    }

    public void printStackTrace() {
        System.out.println("stack size: " + this.executors.size());
        for (int i = this.executors.size() - 1; i >= 0; --i) {
            System.out.println("(" + i + ") " + ((StatementExecutor)this.executors.get(i)).toString());
        }
    }

    public void addGoals(Queue<Formula> queue, Goal goal) {
        for (int i = 0; i < this.executors.size() - 1; ++i) {
            ((StatementExecutor)this.executors.get(i)).addGoals(queue, goal);
        }
    }

    public RuleExecutor parent() {
        return this.parent;
    }

    public Map<Integer, Term> getAllBindings() {
        HashMap<Integer, Term> lBindings = new HashMap<Integer, Term>();
        lBindings.putAll(this.bindings);
        for (StatementExecutor executor : this.executors) {
            Map<Integer, Term> b = executor.bindings();
            if (b == null) continue;
            lBindings.putAll(b);
        }
        return lBindings;
    }

    public Intention intention() {
        return this.intention;
    }
}

