/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.Agent;
import astra.core.Task;
import astra.execution.SchedulerStrategy;

public class Scheduler {
    public static final int ACTIVE = 0;
    public static final int INACTIVE = 1;
    public static final int STEPPING = 2;
    public static final int WAITING = 3;
    private static SchedulerStrategy strategy;

    public static void setStrategy(SchedulerStrategy s) {
        if (strategy != null) {
            strategy.stop();
        }
        strategy = s;
    }

    public static boolean hasStrategy() {
        return strategy != null;
    }

    public static void schedule(Agent agent) {
        strategy.schedule(agent);
    }

    public static void schedule(Task task) {
        strategy.schedule(task);
    }

    public static void setThreadPoolSize(int size) {
        strategy.setThreadPoolSize(size);
    }

    public static void setState(Agent agent, int state) {
        strategy.setState(agent, state);
    }

    public static void setSleepTime(long sleepTime) {
        strategy.setSleepTime(sleepTime);
    }

    public static int getState(Agent agent) {
        return strategy.getState(agent);
    }

    public static void shutdown() {
        strategy.shutdown();
    }

    public static void resumeIfWaiting(Agent agent) {
        if (strategy.getState(agent) == 3) {
            strategy.setState(agent, 0);
            strategy.schedule(agent);
        }
    }

    public static void displayStats() {
        System.out.println(strategy);
    }
}

