/*
 * Decompiled with CFR 0.152.
 */
package astra.core;

import astra.core.Intention;
import astra.debugger.Breakpoints;
import astra.formula.Formula;
import astra.formula.Goal;
import astra.statement.StatementHandler;
import astra.term.Term;
import astra.term.Variable;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;

public class StatementExecutor {
    private Map<Integer, Term> bindings;
    private StatementHandler handler;
    private boolean finished = false;

    public StatementExecutor(StatementHandler handler, Map<Integer, Term> bindings) {
        this.bindings = bindings;
        this.handler = handler;
    }

    public StatementExecutor(StatementHandler handler) {
        this(handler, null);
    }

    public boolean execute(Intention intention) {
        Breakpoints.getInstance().check(intention.agent, this.handler.statement());
        this.finished = !this.handler.execute(intention);
        return !this.finished;
    }

    public Map<Integer, Term> bindings() {
        return this.bindings;
    }

    public boolean updateVariable(Variable term, Term logic) {
        if (this.bindings.containsKey(term.id())) {
            this.bindings.put(term.id(), logic);
            return true;
        }
        return false;
    }

    public StatementHandler getStatement() {
        return this.handler;
    }

    public boolean rollback(Intention intention) {
        return this.handler.onFail(intention);
    }

    public void buildFailureTrace(Stack<StatementHandler> failureTrace) {
        failureTrace.push(this.handler);
    }

    public String toString() {
        return this.handler.toString();
    }

    public void addGoals(Queue<Formula> queue, Goal goal) {
        this.handler.addGoals(queue, goal);
    }

    public boolean isFinished() {
        return this.finished;
    }
}

