/*
 * Decompiled with CFR 0.152.
 */
package astra.debugger;

import astra.core.Agent;
import astra.core.Rule;
import astra.debugger.DebuggerWorker;
import astra.event.Event;
import astra.formula.Formula;
import astra.statement.Block;
import astra.statement.Statement;
import astra.term.Term;
import astra.term.Variable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Breakpoints {
    private static Breakpoints instance = null;
    private Map<String, State> states = new HashMap<String, State>();
    private Map<String, List<Integer>> breakpoints = new HashMap<String, List<Integer>>();
    private DebuggerWorker worker = null;

    public static Breakpoints getInstance() {
        return instance == null ? (instance = new Breakpoints()) : instance;
    }

    public void setWorker(DebuggerWorker _worker) {
        this.worker = _worker;
    }

    private State getState(Agent agent) {
        State state = this.states.get(agent.name());
        if (state == null) {
            state = new State();
            this.states.put(agent.name(), state);
        }
        return state;
    }

    public void check(Agent agent, Rule rule, Event _event, Map<Integer, Term> bindings) {
        State state = this.getState(agent);
        String clazz = rule.getASTRAClass();
        int line = -1;
        if (state.mode == 3 || state.mode == 2) {
            line = rule.beginLine();
        } else {
            List<Integer> lines = this.breakpoints.get(clazz);
            if (lines != null) {
                for (int i = 0; line == -1 && i < lines.size(); ++i) {
                    int l = lines.get(i);
                    if (l > rule.endLine()) {
                        line = l;
                    }
                    if (l < rule.beginLine() || l > rule.endLine()) continue;
                    state.mode = 0;
                    state.level = 0;
                    line = l;
                }
            }
        }
        if (line > -1) {
            this.worker.notify("BP\nRULE\n" + clazz + "\n" + line + "\n" + _event + "\n" + this.encode(bindings));
            this.pause();
        }
    }

    private synchronized void pause() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void check(Agent agent, Rule rule, Formula context, List<Map<Integer, Term>> results) {
        State state = this.getState(agent);
        String clazz = rule.getASTRAClass();
        int line = -1;
        if (state.mode == 3) {
            line = rule.beginLine();
            this.worker.notify("BP\nCTXT\n" + clazz + "\n" + line + "\n" + context + "\n" + this.encode(results));
            this.pause();
        }
    }

    public void check(Agent agent, Statement statement) {
        if (statement instanceof Block) {
            return;
        }
        State state = this.getState(agent);
        String clazz = statement.getASTRAClass();
        int line = -1;
        if (state.mode == 3 || state.mode == 2 && state.level == 2) {
            line = statement.beginLine();
        } else {
            List<Integer> lines = this.breakpoints.get(clazz);
            if (lines != null) {
                for (int i = 0; line == -1 && i < lines.size(); ++i) {
                    int l = lines.get(i);
                    if (l > statement.endLine()) {
                        line = l;
                    }
                    if (l < statement.beginLine() || l > statement.endLine()) continue;
                    state.mode = 0;
                    state.level = 0;
                    line = l;
                }
            }
        }
        if (line > -1) {
            this.worker.notify("BP\nSTMT\n" + clazz + "\n" + line + "\n" + statement);
            this.pause();
        }
    }

    private String encode(Map<Integer, Term> bindings) {
        String out = "";
        for (Map.Entry<Integer, Term> entry : bindings.entrySet()) {
            if (out.length() > 0) {
                out = out + " ";
            }
            out = out + Variable.mapper.fromId(entry.getKey()) + "=" + entry.getValue().toString();
        }
        return out;
    }

    private String encode(List<Map<Integer, Term>> results) {
        String out = "";
        for (Map<Integer, Term> bindings : results) {
            if (out.length() > 0) {
                out = out + "\n";
            }
            out = out + this.encode(bindings);
        }
        return null;
    }

    public void set(Class<?> clazz, int line) {
        this.set(clazz.getCanonicalName(), line);
    }

    public void set(String clazz, int line) {
        List<Integer> lines = this.breakpoints.get(clazz);
        if (lines == null) {
            lines = new LinkedList<Integer>();
            this.breakpoints.put(clazz, lines);
        }
        lines.add(line);
        Collections.sort(lines);
    }

    public synchronized void stepIn(String name) {
        State state = this.getState(Agent.getAgent(name));
        state.mode = 3;
        this.notify();
    }

    public synchronized void stepOver(String name) {
        State state = this.getState(Agent.getAgent(name));
        state.mode = 2;
        this.notify();
    }

    public static class State {
        public static final int PAUSED = 0;
        public static final int RUNNING = 1;
        public static final int STEPOVER = 2;
        public static final int STEPIN = 3;
        public static final int LEVEL_RULE = 0;
        public static final int LEVEL_CONTEXT = 1;
        public static final int LEVEL_STATEMENT = 2;
        int level;
        int mode = 1;
    }
}

