/*
 * Decompiled with CFR 0.152.
 */
package astra.debugger;

import astra.debugger.ChangeRequest;
import astra.debugger.DebuggerHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DebuggerClient
implements Runnable {
    private List<ChangeRequest> pendingChanges = new LinkedList<ChangeRequest>();
    private Map<SocketChannel, List<ByteBuffer>> pendingData = new HashMap<SocketChannel, List<ByteBuffer>>();
    private Map<SocketChannel, DebuggerHandler> rspHandlers = Collections.synchronizedMap(new HashMap());
    private Selector selector;
    private ByteBuffer readBuffer = ByteBuffer.allocate(8192);
    private InetAddress host = null;
    private int port;

    public DebuggerClient(String host, int port) throws IOException {
        this.host = InetAddress.getByName(host);
        this.port = port;
        this.selector = this.initSelector();
    }

    private Selector initSelector() throws IOException {
        return SelectorProvider.provider().openSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketChannel initiateConnection() throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(this.host, this.port));
        List<ChangeRequest> list = this.pendingChanges;
        synchronized (list) {
            this.pendingChanges.add(new ChangeRequest(socketChannel, 1, 8));
        }
        return socketChannel;
    }

    private void finishConnection(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        try {
            socketChannel.finishConnect();
        }
        catch (IOException e) {
            e.printStackTrace();
            key.cancel();
            return;
        }
        key.interestOps(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                block10: while (true) {
                    List<ChangeRequest> list = this.pendingChanges;
                    synchronized (list) {
                        for (ChangeRequest change : this.pendingChanges) {
                            switch (change.type) {
                                case 2: {
                                    SelectionKey key = change.socket.keyFor(this.selector);
                                    key.interestOps(change.ops);
                                    break;
                                }
                                case 1: {
                                    change.socket.register(this.selector, change.ops);
                                }
                            }
                        }
                        this.pendingChanges.clear();
                    }
                    this.selector.select();
                    Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!selectedKeys.hasNext()) continue block10;
                        SelectionKey key = selectedKeys.next();
                        selectedKeys.remove();
                        if (!key.isValid()) continue;
                        if (key.isConnectable()) {
                            this.finishConnection(key);
                            continue;
                        }
                        if (key.isReadable()) {
                            this.read(key);
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        this.write(key);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void read(SelectionKey key) throws IOException {
        int bytesRead;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        this.readBuffer.clear();
        try {
            bytesRead = socketChannel.read(this.readBuffer);
        }
        catch (IOException e) {
            key.cancel();
            socketChannel.close();
            return;
        }
        if (bytesRead == -1) {
            key.channel().close();
            key.cancel();
            return;
        }
        this.handleResponse(socketChannel, this.readBuffer.array(), bytesRead);
    }

    private void handleResponse(SocketChannel socketChannel, byte[] data, int numRead) throws IOException {
        byte[] rspData = new byte[numRead];
        System.arraycopy(data, 0, rspData, 0, numRead);
        DebuggerHandler handler = this.rspHandlers.get(socketChannel);
        if (handler.handleResponse(rspData)) {
            socketChannel.close();
            socketChannel.keyFor(this.selector).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
        synchronized (map) {
            List<ByteBuffer> queue = this.pendingData.get(socketChannel);
            while (!queue.isEmpty()) {
                ByteBuffer buf = queue.get(0);
                socketChannel.write(buf);
                if (buf.remaining() > 0) break;
                queue.remove(0);
            }
            if (queue.isEmpty()) {
                key.interestOps(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] data, DebuggerHandler handler) throws IOException {
        SocketChannel socket = this.initiateConnection();
        this.rspHandlers.put(socket, handler);
        Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
        synchronized (map) {
            List<ByteBuffer> queue = this.pendingData.get(socket);
            if (queue == null) {
                queue = new ArrayList<ByteBuffer>();
                this.pendingData.put(socket, queue);
            }
            queue.add(ByteBuffer.wrap(data));
        }
        this.selector.wakeup();
    }
}

