/*
 * Decompiled with CFR 0.152.
 */
package astra.debugger;

import astra.debugger.ChangeRequest;
import astra.debugger.DebuggerWorker;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DebuggerServer
implements Runnable {
    private ServerSocketChannel serverChannel;
    private List<ChangeRequest> changeRequests = new LinkedList<ChangeRequest>();
    private Map<SocketChannel, List<ByteBuffer>> pendingData = new HashMap<SocketChannel, List<ByteBuffer>>();
    private Selector selector;
    private ByteBuffer readBuffer = ByteBuffer.allocate(8192);
    private InetAddress host = null;
    private int port;
    private DebuggerWorker worker;

    public DebuggerServer(int port, DebuggerWorker worker) throws IOException {
        this.port = port;
        this.worker = worker;
        this.selector = this.initSelector();
    }

    private Selector initSelector() throws IOException {
        AbstractSelector socketSelector = SelectorProvider.provider().openSelector();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(this.host, this.port);
        this.serverChannel.socket().bind(isa);
        this.serverChannel.register(socketSelector, 16);
        System.out.println("DebugServer listening on port: " + this.port);
        return socketSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                block11: while (true) {
                    List<ChangeRequest> list = this.changeRequests;
                    synchronized (list) {
                        for (ChangeRequest change : this.changeRequests) {
                            switch (change.type) {
                                case 2: {
                                    SelectionKey key = change.socket.keyFor(this.selector);
                                    try {
                                        key.interestOps(change.ops);
                                        break;
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                        System.exit(1);
                                    }
                                }
                            }
                        }
                        this.changeRequests.clear();
                    }
                    this.selector.select();
                    Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!selectedKeys.hasNext()) continue block11;
                        SelectionKey key = selectedKeys.next();
                        selectedKeys.remove();
                        if (!key.isValid()) continue;
                        if (key.isAcceptable()) {
                            this.accept(key);
                            continue;
                        }
                        if (key.isReadable()) {
                            this.read(key);
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        this.write(key);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void accept(SelectionKey key) throws IOException {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = serverSocketChannel.accept();
        socketChannel.configureBlocking(false);
        socketChannel.register(this.selector, 1);
    }

    private void read(SelectionKey key) throws IOException {
        int bytesRead;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        this.readBuffer.clear();
        try {
            bytesRead = socketChannel.read(this.readBuffer);
        }
        catch (IOException e) {
            key.cancel();
            socketChannel.close();
            return;
        }
        if (bytesRead == -1) {
            key.channel().close();
            key.cancel();
            return;
        }
        this.worker.processData(this, socketChannel, this.readBuffer.array(), bytesRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
        synchronized (map) {
            List<ByteBuffer> queue = this.pendingData.get(socketChannel);
            while (!queue.isEmpty()) {
                ByteBuffer buf = queue.get(0);
                socketChannel.write(buf);
                if (buf.remaining() > 0) break;
                queue.remove(0);
            }
            if (queue.isEmpty()) {
                key.interestOps(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SocketChannel socket, byte[] data) {
        List<ChangeRequest> list = this.changeRequests;
        synchronized (list) {
            this.changeRequests.add(new ChangeRequest(socket, 2, 4));
            Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
            synchronized (map) {
                List<ByteBuffer> queue = this.pendingData.get(socket);
                if (queue == null) {
                    queue = new ArrayList<ByteBuffer>();
                    this.pendingData.put(socket, queue);
                }
                queue.add(ByteBuffer.wrap(data));
            }
        }
        this.selector.wakeup();
    }
}

