/*
 * Decompiled with CFR 0.152.
 */
package astra.debugger;

import astra.debugger.BreakpointCommand;
import astra.debugger.DebuggerCommand;
import astra.debugger.DebuggerServer;
import astra.debugger.StartCommand;
import astra.debugger.StepInCommand;
import astra.debugger.StepOverCommand;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DebuggerWorker
implements Runnable {
    static Map<String, DebuggerCommand> commands = new HashMap<String, DebuggerCommand>();
    private ConcurrentLinkedQueue<String> notifications = new ConcurrentLinkedQueue();
    private List<ServerDataEvent> queue = new LinkedList<ServerDataEvent>();
    private String clazz;

    public DebuggerWorker(String clazz) {
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processData(DebuggerServer server, SocketChannel socket, byte[] data, int count) {
        byte[] dataCopy = new byte[count];
        System.arraycopy(data, 0, dataCopy, 0, count);
        List<ServerDataEvent> list = this.queue;
        synchronized (list) {
            this.queue.add(new ServerDataEvent(server, socket, dataCopy));
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            ServerDataEvent dataEvent;
            List<ServerDataEvent> list = this.queue;
            synchronized (list) {
                while (this.queue.isEmpty()) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                dataEvent = this.queue.remove(0);
            }
            String line = new String(dataEvent.data);
            String[] bits = line.split(" ");
            String response = "?";
            DebuggerCommand command = commands.get(bits[0]);
            if (command != null) {
                response = command.execute(this, bits);
            }
            while (!this.notifications.isEmpty()) {
                dataEvent.server.send(dataEvent.socket, (this.notifications.poll() + "\n").getBytes());
            }
            dataEvent.server.send(dataEvent.socket, response.getBytes());
        }
    }

    public void notify(String event) {
        this.notifications.add(event);
    }

    public String getMainClass() {
        return this.clazz;
    }

    static {
        commands.put("BP", new BreakpointCommand());
        commands.put("START", new StartCommand());
        commands.put("IDLE", new StartCommand());
        commands.put("STEPIN", new StepInCommand());
        commands.put("STEPOVER", new StepOverCommand());
    }

    public static class ServerDataEvent {
        private DebuggerServer server;
        private SocketChannel socket;
        private byte[] data;

        public ServerDataEvent(DebuggerServer server, SocketChannel socket, byte[] data) {
            this.server = server;
            this.socket = socket;
            this.data = data;
        }
    }
}

