/*
 * Decompiled with CFR 0.152.
 */
package astra.execution;

import astra.core.Agent;
import astra.core.Task;
import astra.execution.SchedulerStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AdaptiveSchedulerStrategy
implements SchedulerStrategy {
    private ExecutorService executor = Executors.newFixedThreadPool(5);
    private Map<String, Integer> agents = new HashMap<String, Integer>();

    @Override
    public void schedule(final Agent agent) {
        Integer state = null;
        state = this.agents.get(agent.name());
        if (state == null) {
            state = 0;
            this.agents.put(agent.name(), state);
        }
        if (state == 0) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        agent.execute();
                    }
                    catch (Throwable th) {
                        System.err.println("Major Error in Agent: " + agent.name());
                        th.printStackTrace();
                        System.exit(0);
                    }
                    if (agent.hasSensors() || !agent.hasEvents() || !agent.intentions().isEmpty() || agent.hasActiveFunction()) {
                        AdaptiveSchedulerStrategy.this.schedule(agent);
                    } else {
                        AdaptiveSchedulerStrategy.this.agents.put(agent.name(), 3);
                    }
                }
            });
        }
    }

    @Override
    public void schedule(Task task) {
        this.executor.submit(task);
    }

    @Override
    public void setThreadPoolSize(int size) {
        ExecutorService oldExecutor = this.executor;
        this.executor = Executors.newFixedThreadPool(size);
        oldExecutor.shutdown();
    }

    @Override
    public void stop() {
    }

    @Override
    public void setState(Agent agent, int state) {
        this.agents.put(agent.name(), state);
    }

    @Override
    public synchronized int getState(Agent agent) {
        if (!this.agents.containsKey(agent.name())) {
            return 0;
        }
        return this.agents.get(agent.name());
    }

    @Override
    public void setSleepTime(long sleepTime) {
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
    }
}

