/*
 * Decompiled with CFR 0.152.
 */
package astra.execution;

import astra.core.Agent;
import astra.core.Scheduler;
import astra.core.Task;
import astra.execution.SchedulerStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BasicSchedulerStrategy
implements SchedulerStrategy {
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private Map<String, Integer> agents = new HashMap<String, Integer>();
    private long sleepTime = 50L;

    @Override
    public void schedule(final Agent agent) {
        Integer state = this.agents.get(agent.name());
        if (state == null) {
            state = 0;
            this.agents.put(agent.name(), state);
        }
        if (state == 0) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        agent.execute();
                    }
                    catch (Throwable th) {
                        System.err.println("Major Error in Agent: " + agent.name());
                        th.printStackTrace();
                        System.exit(0);
                    }
                    try {
                        Thread.sleep(BasicSchedulerStrategy.this.sleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Scheduler.schedule(agent);
                }
            });
        }
    }

    @Override
    public void schedule(Task task) {
        this.executor.submit(task);
    }

    @Override
    public void setThreadPoolSize(int size) {
        ExecutorService oldExecutor = this.executor;
        this.executor = Executors.newFixedThreadPool(size);
        oldExecutor.shutdown();
    }

    @Override
    public void stop() {
    }

    @Override
    public void setState(Agent agent, int state) {
        this.agents.put(agent.name(), state);
    }

    @Override
    public int getState(Agent agent) {
        return this.agents.get(agent.name());
    }

    @Override
    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }
}

