/*
 * Decompiled with CFR 0.152.
 */
package astra.execution;

import astra.core.Agent;
import astra.core.Task;
import astra.execution.SchedulerStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class FairSchedulerStrategy
implements SchedulerStrategy {
    List<Agent> list = new CopyOnWriteArrayList<Agent>();
    Map<String, Integer> counts = new HashMap<String, Integer>();
    boolean finished = false;

    public FairSchedulerStrategy() {
        new Thread(){

            @Override
            public void run() {
                while (!FairSchedulerStrategy.this.finished) {
                    FairSchedulerStrategy.this.list.parallelStream().forEach(agent -> {
                        FairSchedulerStrategy.this.counts.put(agent.name(), FairSchedulerStrategy.this.counts.get(agent.name()) + 1);
                        agent.execute();
                    });
                }
            }
        }.start();
    }

    @Override
    public void schedule(Agent agent) {
        this.counts.put(agent.name(), 0);
        this.list.add(agent);
    }

    @Override
    public void schedule(Task task) {
    }

    public String toString() {
        return this.counts.toString();
    }

    @Override
    public void setThreadPoolSize(int size) {
    }

    @Override
    public void stop() {
    }

    @Override
    public void setState(Agent agent, int state) {
    }

    @Override
    public int getState(Agent agent) {
        return 0;
    }

    @Override
    public void setSleepTime(long sleepTime) {
    }

    @Override
    public void shutdown() {
        this.finished = true;
        this.list.clear();
    }
}

