/*
 * Decompiled with CFR 0.152.
 */
package astra.formula;

import astra.formula.Formula;
import astra.reasoner.util.LogicVisitor;
import astra.term.Term;

public class Comparison
implements Formula {
    private static final long serialVersionUID = 471522387455973717L;
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN_OR_EQUAL = "<=";
    public static final String GREATER_THAN_OR_EQUAL = ">=";
    public static final String EQUAL = "==";
    public static final String NOT_EQUAL = "~=";
    public static final String OTHER_NOT_EQUAL = "!=";
    private String operator;
    private Term left;
    private Term right;

    public Comparison(String operator, Term left, Term right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public String operator() {
        return this.operator;
    }

    public Term left() {
        return this.left;
    }

    public Term right() {
        return this.right;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.left + " " + this.operator + " " + this.right;
    }

    @Override
    public boolean matches(Formula formula) {
        return formula instanceof Comparison & this.operator.equals(((Comparison)formula).operator) && this.left.matches(((Comparison)formula).left) && this.right.matches(((Comparison)formula).right);
    }
}

