/*
 * Decompiled with CFR 0.152.
 */
package astra.formula;

import astra.formula.Formula;
import astra.reasoner.util.LogicVisitor;
import astra.reasoner.util.StringMapper;
import astra.term.Term;

public class Predicate
implements Formula {
    private static final long serialVersionUID = -8052462903760625155L;
    public static final Predicate TRUE = new Predicate("true");
    public static final Predicate FALSE = new Predicate("false");
    private static StringMapper mapper;
    private int id;
    Term[] terms;

    public Predicate(String predicate, Term[] terms) {
        if (mapper == null) {
            mapper = new StringMapper();
        }
        this.id = mapper.toId(predicate);
        this.terms = terms;
    }

    private Predicate(int id, Term[] terms) {
        this.id = id;
        this.terms = terms;
    }

    public Predicate(String predicate) {
        this(predicate, Term.EMPTY_ARRAY);
    }

    public Term getTerm(int i) {
        return this.terms[i];
    }

    public int size() {
        return this.terms.length;
    }

    public int id() {
        return this.id;
    }

    public Term[] terms() {
        return this.terms;
    }

    public String toString() {
        String out = mapper.fromId(this.id);
        if (this.equals(TRUE) || this.equals(FALSE)) {
            return out;
        }
        out = out + "(";
        if (this.terms.length > 0) {
            for (int i = 0; i < this.terms.length; ++i) {
                if (i > 0) {
                    out = out + ",";
                }
                out = out + this.terms[i].toString();
            }
        }
        out = out + ")";
        return out;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    public String predicate() {
        return mapper.fromId(this.id);
    }

    @Override
    public boolean matches(Formula formula) {
        if (formula instanceof Predicate) {
            Predicate p = (Predicate)formula;
            if (p.id != this.id || p.terms.length != this.terms.length) {
                return false;
            }
            for (int i = 0; i < this.terms.length; ++i) {
                if (this.terms[i].matches(p.terms[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Predicate) {
            Predicate p = (Predicate)object;
            if (p.id != this.id || p.size() != this.terms.length) {
                return false;
            }
            for (int i = 0; i < this.terms.length; ++i) {
                if (this.terms[i].equals(p.getTerm(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Term termAt(int i) {
        return this.terms[i];
    }

    public Predicate clone() {
        Term[] values = new Term[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            values[i] = this.terms[i].clone();
        }
        return new Predicate(this.id, values);
    }
}

