/*
 * Decompiled with CFR 0.152.
 */
package astra.messaging;

import astra.core.Agent;
import astra.messaging.AstraMessage;
import astra.messaging.LocalMQService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class MessageService {
    static Map<String, MessageService> services = new HashMap<String, MessageService>();
    static List<String> serviceIds = new LinkedList<String>();

    public static boolean hasService(String id) {
        return services.containsKey(id);
    }

    public static void installService(String id, MessageService service) {
        services.put(id, service);
        serviceIds.add(id);
    }

    public static MessageService getService(String id) {
        return services.get(id);
    }

    public static boolean send(AstraMessage message) {
        if (serviceIds.isEmpty()) {
            System.out.println("[MessageService] No service installed - using LocalMQService");
            MessageService.installService("local", new LocalMQService());
        }
        for (String id : serviceIds) {
            if (!services.get(id).sendMessage(message)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean sendMessage(AstraMessage var1);

    public abstract void configure(String var1, String var2);

    public abstract void start();

    public boolean receiveMessage(AstraMessage message) {
        boolean received = false;
        for (String name : message.receivers) {
            Agent receiver = Agent.getAgent(name);
            if (receiver == null) continue;
            receiver.receive(message);
            received = true;
        }
        return received;
    }
}

